/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.sched.TimerSubscription;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import java.util.concurrent.TimeUnit;
import org.agrona.DeadlineTimerWheel;
import org.agrona.collections.Long2ObjectHashMap;

public final class ActorTimerQueue
extends DeadlineTimerWheel {
    private static final int DEFAULT_TICKS_PER_WHEEL = 32;
    private final Long2ObjectHashMap<TimerSubscription> timerJobMap = new Long2ObjectHashMap();
    private final DeadlineTimerWheel.TimerHandler timerHandler = new DeadlineTimerWheel.TimerHandler(){

        public boolean onTimerExpiry(TimeUnit timeUnit, long now, long timerId) {
            TimerSubscription timer = (TimerSubscription)ActorTimerQueue.this.timerJobMap.remove(timerId);
            if (timer != null) {
                timer.onTimerExpired(timeUnit, now);
            }
            return true;
        }
    };

    public ActorTimerQueue(ActorClock clock) {
        this(clock, 32);
    }

    public ActorTimerQueue(ActorClock clock, int ticksPerWheel) {
        super(TimeUnit.MILLISECONDS, clock.getTimeMillis(), 1L, ticksPerWheel);
    }

    public void processExpiredTimers(ActorClock clock) {
        int timersProcessed = 0;
        while ((timersProcessed = this.poll(clock.getTimeMillis(), this.timerHandler, Integer.MAX_VALUE)) > 0) {
        }
    }

    public void schedule(TimerSubscription timer, ActorClock now) {
        long deadline = now.getTimeMillis() + this.timeUnit().convert(timer.getDeadline(), timer.getTimeUnit());
        long timerId = this.scheduleTimer(deadline);
        timer.setTimerId(timerId);
        this.timerJobMap.put(timerId, (Object)timer);
    }

    public void remove(TimerSubscription timer) {
        long timerId = timer.getTimerId();
        this.timerJobMap.remove(timerId);
        this.cancelTimer(timerId);
    }
}

