/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorCondition;
import io.camunda.zeebe.util.sched.ActorConditionImpl;
import io.camunda.zeebe.util.sched.ActorFutureSubscription;
import io.camunda.zeebe.util.sched.ActorJob;
import io.camunda.zeebe.util.sched.ActorPriority;
import io.camunda.zeebe.util.sched.ActorTask;
import io.camunda.zeebe.util.sched.ActorThread;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.ScheduledTimer;
import io.camunda.zeebe.util.sched.TimerSubscription;
import io.camunda.zeebe.util.sched.channel.ChannelConsumerCondition;
import io.camunda.zeebe.util.sched.channel.ChannelSubscription;
import io.camunda.zeebe.util.sched.channel.ConsumableChannel;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.AllCompletedFutureConsumer;
import io.camunda.zeebe.util.sched.future.FutureContinuationRunnable;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class ActorControl
implements ConcurrencyControl {
    final ActorTask task;
    private final Actor actor;

    public ActorControl(Actor actor) {
        this.actor = actor;
        this.task = new ActorTask(actor);
    }

    private ActorControl(ActorTask task) {
        this.actor = task.actor;
        this.task = task;
    }

    public static ActorControl current() {
        ActorThread actorThread = ActorThread.ensureCalledFromActorThread("ActorControl#current");
        return new ActorControl(actorThread.currentTask);
    }

    public void setSchedulingHints(int hints) {
        this.ensureCalledFromWithinActor("resubmit(...)");
        this.task.setUpdatedSchedulingHints(hints);
    }

    public ChannelSubscription consume(ConsumableChannel channel, Runnable consumer) {
        this.ensureCalledFromWithinActor("consume(...)");
        ActorJob job = new ActorJob();
        job.setRunnable(consumer);
        job.setAutoCompleting(false);
        job.onJobAddedToTask(this.task);
        ChannelConsumerCondition subscription = new ChannelConsumerCondition(job, channel);
        job.setSubscription(subscription);
        channel.registerConsumer(subscription);
        return subscription;
    }

    public ActorCondition onCondition(String conditionName, Runnable conditionAction) {
        this.ensureCalledFromWithinActor("onCondition(...)");
        ActorJob job = new ActorJob();
        job.setRunnable(conditionAction);
        job.onJobAddedToTask(this.task);
        ActorConditionImpl condition = new ActorConditionImpl(conditionName, job);
        job.setSubscription(condition);
        return condition;
    }

    public <T> ActorFuture<T> call(Callable<T> callable) {
        ActorThread runner = ActorThread.current();
        if (runner != null && runner.getCurrentTask() == this.task) {
            throw new UnsupportedOperationException("Incorrect usage of actor.call(...) cannot be called from current actor.");
        }
        ActorJob job = new ActorJob();
        ActorFuture future = job.setCallable(callable);
        job.onJobAddedToTask(this.task);
        job.setAutoCompleting(true);
        this.task.submit(job);
        return future;
    }

    public ActorFuture<Void> call(Runnable action) {
        Callable<Void> c = () -> {
            action.run();
            return null;
        };
        return this.call(c);
    }

    public void runUntilDone(Runnable runnable) {
        this.ensureCalledFromWithinActor("runUntilDone(...)");
        this.scheduleRunnable(runnable, false);
    }

    public ScheduledTimer runDelayed(Duration delay, Runnable runnable) {
        this.ensureCalledFromWithinActor("runDelayed(...)");
        return this.scheduleTimer(delay, false, runnable);
    }

    public ScheduledTimer runAtFixedRate(Duration delay, Runnable runnable) {
        this.ensureCalledFromWithinActor("runAtFixedRate(...)");
        return this.scheduleTimer(delay, true, runnable);
    }

    private TimerSubscription scheduleTimer(Duration delay, boolean isRecurring, Runnable runnable) {
        ActorJob job = new ActorJob();
        job.setRunnable(runnable);
        job.onJobAddedToTask(this.task);
        TimerSubscription timerSubscription = new TimerSubscription(job, delay.toNanos(), TimeUnit.NANOSECONDS, isRecurring);
        job.setSubscription(timerSubscription);
        timerSubscription.submit();
        return timerSubscription;
    }

    @Override
    public <T> void runOnCompletion(ActorFuture<T> future, BiConsumer<T, Throwable> callback) {
        this.ensureCalledFromWithinActor("runOnCompletion(...)");
        ActorTask.ActorLifecyclePhase lifecyclePhase = this.task.getLifecyclePhase();
        if (lifecyclePhase != ActorTask.ActorLifecyclePhase.CLOSE_REQUESTED && lifecyclePhase != ActorTask.ActorLifecyclePhase.CLOSED) {
            this.submitContinuationJob(future, callback, job -> new ActorFutureSubscription(future, (ActorJob)job, lifecyclePhase.getValue()));
        }
    }

    @Override
    public void run(Runnable action) {
        this.scheduleRunnable(action, true);
    }

    public void submit(Runnable action) {
        ActorThread currentThread = ActorThread.current();
        ActorTask currentTask = currentThread == null ? null : currentThread.getCurrentTask();
        ActorJob job = currentThread != null && currentTask == this.task ? currentThread.newJob() : new ActorJob();
        job.setRunnable(action);
        job.setAutoCompleting(true);
        job.onJobAddedToTask(this.task);
        this.task.submit(job);
        if (currentTask != null && currentTask == this.task) {
            this.yieldThread();
        }
    }

    public <T> void runOnCompletionBlockingCurrentPhase(ActorFuture<T> future, BiConsumer<T, Throwable> callback) {
        this.ensureCalledFromWithinActor("runOnCompletionBlockingCurrentPhase(...)");
        ActorTask.ActorLifecyclePhase lifecyclePhase = this.task.getLifecyclePhase();
        if (lifecyclePhase != ActorTask.ActorLifecyclePhase.CLOSED) {
            this.submitContinuationJob(future, callback, job -> new ActorFutureSubscription(future, (ActorJob)job, this.task.getLifecyclePhase().getValue() | ActorTask.ActorLifecyclePhase.CLOSE_REQUESTED.getValue()));
        }
    }

    private <T> void submitContinuationJob(ActorFuture<T> future, BiConsumer<T, Throwable> callback, Function<ActorJob, ActorFutureSubscription> futureSubscriptionSupplier) {
        ActorJob continuationJob = new ActorJob();
        continuationJob.setRunnable(new FutureContinuationRunnable<T>(future, callback));
        continuationJob.setAutoCompleting(true);
        continuationJob.onJobAddedToTask(this.task);
        ActorFutureSubscription subscription = futureSubscriptionSupplier.apply(continuationJob);
        continuationJob.setSubscription(subscription);
        future.block(this.task);
    }

    public <T> void runOnCompletion(Collection<ActorFuture<T>> futures, Consumer<Throwable> callback) {
        if (!futures.isEmpty()) {
            AllCompletedFutureConsumer futureConsumer = new AllCompletedFutureConsumer(futures.size(), callback);
            for (ActorFuture<T> future : futures) {
                this.runOnCompletion(future, futureConsumer);
            }
        } else {
            callback.accept(null);
        }
    }

    public void yieldThread() {
        ActorJob job = this.ensureCalledFromWithinActor("yieldThread()");
        job.getTask().yieldThread();
    }

    public ActorFuture<Void> close() {
        ActorJob closeJob = new ActorJob();
        closeJob.onJobAddedToTask(this.task);
        closeJob.setAutoCompleting(true);
        closeJob.setRunnable(this.task::requestClose);
        this.task.submit(closeJob);
        return this.task.closeFuture;
    }

    private void scheduleRunnable(Runnable runnable, boolean autocompleting) {
        ActorThread currentActorThread = ActorThread.current();
        if (currentActorThread != null && currentActorThread.getCurrentTask() == this.task) {
            ActorJob newJob = currentActorThread.newJob();
            newJob.setRunnable(runnable);
            newJob.setAutoCompleting(autocompleting);
            newJob.onJobAddedToTask(this.task);
            this.task.insertJob(newJob);
        } else {
            ActorJob job = new ActorJob();
            job.setRunnable(runnable);
            job.setAutoCompleting(autocompleting);
            job.onJobAddedToTask(this.task);
            this.task.submit(job);
        }
    }

    public void done() {
        ActorJob job = this.ensureCalledFromWithinActor("done()");
        job.markDone();
    }

    public boolean isClosing() {
        this.ensureCalledFromWithinActor("isClosing()");
        return this.task.isClosing();
    }

    public boolean isClosed() {
        ActorTask.ActorLifecyclePhase lifecyclePhase = this.task.getLifecyclePhase();
        return lifecyclePhase != ActorTask.ActorLifecyclePhase.STARTING && lifecyclePhase != ActorTask.ActorLifecyclePhase.STARTED;
    }

    public void setPriority(ActorPriority priority) {
        ActorThread.ensureCalledFromActorThread("setPriority()");
        this.task.setPriority(priority.getPriorityClass());
    }

    public ActorTask.ActorLifecyclePhase getLifecyclePhase() {
        this.ensureCalledFromWithinActor("getLifecyclePhase()");
        return this.task.getLifecyclePhase();
    }

    public boolean isCalledFromWithinActor(ActorJob job) {
        return job != null && job.getActor() == this.actor;
    }

    private ActorJob ensureCalledFromWithinActor(String methodName) {
        ActorJob currentJob = ActorThread.ensureCalledFromActorThread(methodName).getCurrentJob();
        if (!this.isCalledFromWithinActor(currentJob)) {
            throw new UnsupportedOperationException("Incorrect usage of actor." + methodName + ": must only be called from within the actor itself.");
        }
        return currentJob;
    }

    public void fail() {
        this.ensureCalledFromWithinActor("fail()");
        this.task.fail();
    }
}

