/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.util.sched.ActorControl;
import io.camunda.zeebe.util.sched.ScheduledTimer;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import java.time.Duration;

public class DueDateTimerChecker
implements StreamProcessorLifecycleAware {
    private static final long TIMER_RESOLUTION = Duration.ofMillis(100L).toMillis();
    private final TimerRecord timerRecord = new TimerRecord();
    private final TimerInstanceState timerInstanceState;
    private ActorControl actor;
    private TypedStreamWriter streamWriter;
    private ScheduledTimer scheduledTimer;
    private long nextDueDate = -1L;

    public DueDateTimerChecker(TimerInstanceState timerInstanceState) {
        this.timerInstanceState = timerInstanceState;
    }

    public void scheduleTimer(long dueDate) {
        Duration duration = Duration.ofMillis(dueDate - ActorClock.currentTimeMillis());
        if (this.scheduledTimer == null) {
            this.scheduledTimer = this.actor.runDelayed(duration, this::triggerTimers);
            this.nextDueDate = dueDate;
        } else if (this.nextDueDate - dueDate > TIMER_RESOLUTION) {
            this.scheduledTimer.cancel();
            this.scheduledTimer = this.actor.runDelayed(duration, this::triggerTimers);
            this.nextDueDate = dueDate;
        }
    }

    private void triggerTimers() {
        this.nextDueDate = this.timerInstanceState.findTimersWithDueDateBefore(ActorClock.currentTimeMillis(), this::triggerTimer);
        if (this.nextDueDate > 0L) {
            Duration duration = Duration.ofMillis(this.nextDueDate - ActorClock.currentTimeMillis());
            this.scheduledTimer = this.actor.runDelayed(duration, this::triggerTimers);
        } else {
            this.scheduledTimer = null;
        }
    }

    private boolean triggerTimer(TimerInstance timer) {
        this.timerRecord.reset();
        this.timerRecord.setElementInstanceKey(timer.getElementInstanceKey()).setProcessInstanceKey(timer.getProcessInstanceKey()).setDueDate(timer.getDueDate()).setTargetElementId(timer.getHandlerNodeId()).setRepetitions(timer.getRepetitions()).setProcessDefinitionKey(timer.getProcessDefinitionKey());
        this.streamWriter.reset();
        this.streamWriter.appendFollowUpCommand(timer.getKey(), (Intent)TimerIntent.TRIGGER, (RecordValue)this.timerRecord);
        return this.streamWriter.flush() > 0L;
    }

    @Override
    public void onRecovered(ReadonlyProcessingContext processingContext) {
        this.actor = processingContext.getActor();
        this.streamWriter = processingContext.getLogStreamWriter();
        this.triggerTimers();
    }

    @Override
    public void onPaused() {
        if (this.scheduledTimer != null) {
            this.scheduledTimer.cancel();
            this.scheduledTimer = null;
        }
    }

    @Override
    public void onResumed() {
        if (this.scheduledTimer == null) {
            this.triggerTimers();
        }
    }
}

