/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.processing.streamprocessor.ProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorListener;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorMode;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorFactory;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class StreamProcessorBuilder {
    private final ProcessingContext processingContext;
    private final List<StreamProcessorLifecycleAware> lifecycleListeners = new ArrayList<StreamProcessorLifecycleAware>();
    private TypedRecordProcessorFactory typedRecordProcessorFactory;
    private ActorSchedulingService actorSchedulingService;
    private ZeebeDb zeebeDb;
    private Function<MutableZeebeState, EventApplier> eventApplierFactory;
    private int nodeId;

    public StreamProcessorBuilder() {
        this.processingContext = new ProcessingContext();
    }

    public StreamProcessorBuilder streamProcessorFactory(TypedRecordProcessorFactory typedRecordProcessorFactory) {
        this.typedRecordProcessorFactory = typedRecordProcessorFactory;
        return this;
    }

    public StreamProcessorBuilder actorSchedulingService(ActorSchedulingService actorSchedulingService) {
        this.actorSchedulingService = actorSchedulingService;
        return this;
    }

    public StreamProcessorBuilder nodeId(int nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public StreamProcessorBuilder logStream(LogStream stream) {
        this.processingContext.logStream(stream);
        return this;
    }

    public StreamProcessorBuilder commandResponseWriter(CommandResponseWriter commandResponseWriter) {
        this.processingContext.commandResponseWriter(commandResponseWriter);
        return this;
    }

    public StreamProcessorBuilder listener(StreamProcessorListener listener) {
        this.processingContext.listener(listener);
        return this;
    }

    public StreamProcessorBuilder zeebeDb(ZeebeDb zeebeDb) {
        this.zeebeDb = zeebeDb;
        return this;
    }

    public StreamProcessorBuilder eventApplierFactory(Function<MutableZeebeState, EventApplier> eventApplierFactory) {
        this.eventApplierFactory = eventApplierFactory;
        return this;
    }

    public StreamProcessorBuilder streamProcessorMode(StreamProcessorMode streamProcessorMode) {
        this.processingContext.processorMode(streamProcessorMode);
        return this;
    }

    public TypedRecordProcessorFactory getTypedRecordProcessorFactory() {
        return this.typedRecordProcessorFactory;
    }

    public ProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public ActorSchedulingService getActorSchedulingService() {
        return this.actorSchedulingService;
    }

    public List<StreamProcessorLifecycleAware> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    public ZeebeDb getZeebeDb() {
        return this.zeebeDb;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public Function<MutableZeebeState, EventApplier> getEventApplierFactory() {
        return this.eventApplierFactory;
    }

    public StreamProcessor build() {
        this.validate();
        return new StreamProcessor(this);
    }

    private void validate() {
        Objects.requireNonNull(this.typedRecordProcessorFactory, "No stream processor factory provided.");
        Objects.requireNonNull(this.actorSchedulingService, "No task scheduler provided.");
        Objects.requireNonNull(this.processingContext.getLogStream(), "No log stream provided.");
        Objects.requireNonNull(this.processingContext.getWriters().response(), "No command response writer provided.");
        Objects.requireNonNull(this.zeebeDb, "No database provided.");
        Objects.requireNonNull(this.eventApplierFactory, "No factory for the event supplier provided.");
    }
}

