/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceCommandContext;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceCommandHandler;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;

public final class CancelProcessInstanceHandler
implements ProcessInstanceCommandHandler {
    private static final String MESSAGE_PREFIX = "Expected to cancel a process instance with key '%d', but ";
    private static final String PROCESS_NOT_FOUND_MESSAGE = "Expected to cancel a process instance with key '%d', but no such process was found";
    private static final String PROCESS_NOT_ROOT_MESSAGE = "Expected to cancel a process instance with key '%d', but it is created by a parent process instance. Cancel the root process instance '%d' instead.";

    @Override
    public void handle(ProcessInstanceCommandContext commandContext) {
        ElementInstance elementInstance;
        TypedRecord<ProcessInstanceRecord> command = commandContext.getRecord();
        if (!this.validateCommand(commandContext, command, elementInstance = commandContext.getElementInstance())) {
            return;
        }
        ProcessInstanceRecord value = elementInstance.getValue();
        commandContext.getStreamWriter().appendFollowUpCommand(command.getKey(), (Intent)ProcessInstanceIntent.TERMINATE_ELEMENT, (RecordValue)value);
        commandContext.getResponseWriter().writeEventOnCommand(command.getKey(), (Intent)ProcessInstanceIntent.ELEMENT_TERMINATING, (UnpackedObject)value, command);
    }

    private boolean validateCommand(ProcessInstanceCommandContext commandContext, TypedRecord<ProcessInstanceRecord> command, ElementInstance elementInstance) {
        if (elementInstance == null || !elementInstance.canTerminate() || elementInstance.getParentKey() > 0L) {
            commandContext.reject(RejectionType.NOT_FOUND, String.format(PROCESS_NOT_FOUND_MESSAGE, command.getKey()));
            return false;
        }
        long parentProcessInstanceKey = elementInstance.getValue().getParentProcessInstanceKey();
        if (parentProcessInstanceKey > 0L) {
            long rootProcessInstanceKey = this.getRootProcessInstanceKey(commandContext, parentProcessInstanceKey);
            commandContext.reject(RejectionType.INVALID_STATE, String.format(PROCESS_NOT_ROOT_MESSAGE, command.getKey(), rootProcessInstanceKey));
            return false;
        }
        return true;
    }

    private long getRootProcessInstanceKey(ProcessInstanceCommandContext context, long instanceKey) {
        long parentProcessInstanceKey;
        ElementInstance instance = context.getElementInstanceState().getInstance(instanceKey);
        if (instance != null && (parentProcessInstanceKey = instance.getValue().getParentProcessInstanceKey()) > 0L) {
            return this.getRootProcessInstanceKey(context, parentProcessInstanceKey);
        }
        return instanceKey;
    }
}

