/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message.command;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.CompositeDecoderFlyweight;

public final class MessageHeaderDecoder
implements CompositeDecoderFlyweight {
    public static final int SCHEMA_ID = 6;
    public static final int SCHEMA_VERSION = 1;
    public static final int ENCODED_LENGTH = 8;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private DirectBuffer buffer;

    public MessageHeaderDecoder wrap(DirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 8;
    }

    public int sbeSchemaId() {
        return 6;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public static int blockLengthEncodingOffset() {
        return 0;
    }

    public static int blockLengthEncodingLength() {
        return 2;
    }

    public static int blockLengthSinceVersion() {
        return 0;
    }

    public static int blockLengthNullValue() {
        return 65535;
    }

    public static int blockLengthMinValue() {
        return 0;
    }

    public static int blockLengthMaxValue() {
        return 65534;
    }

    public int blockLength() {
        return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int templateIdEncodingOffset() {
        return 2;
    }

    public static int templateIdEncodingLength() {
        return 2;
    }

    public static int templateIdSinceVersion() {
        return 0;
    }

    public static int templateIdNullValue() {
        return 65535;
    }

    public static int templateIdMinValue() {
        return 0;
    }

    public static int templateIdMaxValue() {
        return 65534;
    }

    public int templateId() {
        return this.buffer.getShort(this.offset + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int schemaIdEncodingOffset() {
        return 4;
    }

    public static int schemaIdEncodingLength() {
        return 2;
    }

    public static int schemaIdSinceVersion() {
        return 0;
    }

    public static int schemaIdNullValue() {
        return 65535;
    }

    public static int schemaIdMinValue() {
        return 0;
    }

    public static int schemaIdMaxValue() {
        return 65534;
    }

    public int schemaId() {
        return this.buffer.getShort(this.offset + 4, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int versionEncodingOffset() {
        return 6;
    }

    public static int versionEncodingLength() {
        return 2;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionNullValue() {
        return 65535;
    }

    public static int versionMinValue() {
        return 0;
    }

    public static int versionMaxValue() {
        return 65534;
    }

    public int version() {
        return this.buffer.getShort(this.offset + 6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        builder.append('(');
        builder.append("blockLength=");
        builder.append(this.blockLength());
        builder.append('|');
        builder.append("templateId=");
        builder.append(this.templateId());
        builder.append('|');
        builder.append("schemaId=");
        builder.append(this.schemaId());
        builder.append('|');
        builder.append("version=");
        builder.append(this.version());
        builder.append(')');
        return builder;
    }
}

