/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message.command;

import io.camunda.zeebe.engine.processing.message.command.CloseMessageSubscriptionDecoder;
import io.camunda.zeebe.engine.processing.message.command.CloseMessageSubscriptionEncoder;
import io.camunda.zeebe.protocol.impl.encoding.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class CloseMessageSubscriptionCommand
extends SbeBufferWriterReader<CloseMessageSubscriptionEncoder, CloseMessageSubscriptionDecoder> {
    private final CloseMessageSubscriptionEncoder encoder = new CloseMessageSubscriptionEncoder();
    private final CloseMessageSubscriptionDecoder decoder = new CloseMessageSubscriptionDecoder();
    private final DirectBuffer messageName = new UnsafeBuffer(0L, 0);
    private int subscriptionPartitionId;
    private long processInstanceKey;
    private long elementInstanceKey;

    protected CloseMessageSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected CloseMessageSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    public void reset() {
        this.subscriptionPartitionId = CloseMessageSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.processInstanceKey = CloseMessageSubscriptionDecoder.processInstanceKeyNullValue();
        this.elementInstanceKey = CloseMessageSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageName.wrap(0L, 0);
    }

    public int getLength() {
        return super.getLength() + CloseMessageSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).processInstanceKey(this.processInstanceKey).elementInstanceKey(this.elementInstanceKey).putMessageName(this.messageName, 0, this.messageName.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.processInstanceKey = this.decoder.processInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        this.decoder.wrapMessageName(this.messageName);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public void setMessageName(DirectBuffer messageName) {
        this.messageName.wrap(messageName);
    }
}

