/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.ByteValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ObjectHashSet;
import org.agrona.concurrent.UnsafeBuffer;

public final class JobBatchActivateProcessor
implements TypedRecordProcessor<JobBatchRecord> {
    private final StateWriter stateWriter;
    private final VariableState variableState;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;
    private final JobState jobState;
    private final KeyGenerator keyGenerator;
    private final long maxRecordLength;
    private final long maxJobBatchLength;
    private final ObjectHashSet<DirectBuffer> variableNames = new ObjectHashSet();
    private final JobMetrics jobMetrics;

    public JobBatchActivateProcessor(Writers writers, ZeebeState state, KeyGenerator keyGenerator, long maxRecordLength, JobMetrics jobMetrics) {
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.jobState = state.getJobState();
        this.variableState = state.getVariableState();
        this.keyGenerator = keyGenerator;
        this.maxRecordLength = maxRecordLength;
        this.maxJobBatchLength = maxRecordLength - 8L;
        this.jobMetrics = jobMetrics;
    }

    @Override
    public void processRecord(TypedRecord<JobBatchRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        JobBatchRecord value = record.getValue();
        if (this.isValid(value)) {
            this.activateJobs(record);
        } else {
            this.rejectCommand(record);
        }
    }

    private boolean isValid(JobBatchRecord record) {
        return record.getMaxJobsToActivate() > 0 && record.getTimeout() > 0L && record.getTypeBuffer().capacity() > 0;
    }

    private void activateJobs(TypedRecord<JobBatchRecord> record) {
        JobBatchRecord value = record.getValue();
        long jobBatchKey = this.keyGenerator.nextKey();
        AtomicInteger amount = new AtomicInteger(value.getMaxJobsToActivate());
        this.collectJobsToActivate(record, amount);
        this.stateWriter.appendFollowUpEvent(jobBatchKey, (Intent)JobBatchIntent.ACTIVATED, (RecordValue)value);
        this.responseWriter.writeEventOnCommand(jobBatchKey, (Intent)JobBatchIntent.ACTIVATED, (UnpackedObject)value, record);
        int activatedJobsCount = record.getValue().getJobKeys().size();
        this.jobMetrics.jobActivated(value.getType(), activatedJobsCount);
    }

    private void collectJobsToActivate(TypedRecord<JobBatchRecord> record, AtomicInteger amount) {
        JobBatchRecord value = record.getValue();
        ValueArray jobIterator = value.jobs();
        ValueArray jobKeyIterator = value.jobKeys();
        this.variableNames.clear();
        ValueArray jobBatchVariables = value.variables();
        jobBatchVariables.forEach(v -> {
            UnsafeBuffer nameCopy = new UnsafeBuffer(new byte[v.getValue().capacity()]);
            nameCopy.putBytes(0, v.getValue(), 0, v.getValue().capacity());
            this.variableNames.add((Object)nameCopy);
        });
        this.jobState.forEachActivatableJobs(value.getTypeBuffer(), (key, jobRecord) -> {
            int remainingAmount = amount.get();
            long deadline = record.getTimestamp() + value.getTimeout();
            jobRecord.setDeadline(deadline).setWorker(value.getWorkerBuffer());
            long elementInstanceKey = jobRecord.getElementInstanceKey();
            if (elementInstanceKey >= 0L) {
                DirectBuffer variables = this.collectVariables((Collection<DirectBuffer>)this.variableNames, elementInstanceKey);
                jobRecord.setVariables(variables);
            } else {
                jobRecord.setVariables(DocumentValue.EMPTY_DOCUMENT);
            }
            if (remainingAmount < 0 || record.getLength() + (long)jobRecord.getLength() > this.maxJobBatchLength) {
                value.setTruncated(true);
                if (value.getJobs().isEmpty()) {
                    this.raiseIncidentJobTooLargeForMessageSize((long)key, (JobRecord)jobRecord);
                }
                return false;
            }
            remainingAmount = amount.decrementAndGet();
            ((LongValue)jobKeyIterator.add()).setValue(key.longValue());
            JobRecord arrayValueJob = (JobRecord)jobIterator.add();
            ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(jobRecord.getLength());
            jobRecord.write((MutableDirectBuffer)buffer, 0);
            arrayValueJob.wrap((DirectBuffer)buffer);
            return remainingAmount > 0;
        });
    }

    private DirectBuffer collectVariables(Collection<DirectBuffer> variableNames, long elementInstanceKey) {
        DirectBuffer variables = variableNames.isEmpty() ? this.variableState.getVariablesAsDocument(elementInstanceKey) : this.variableState.getVariablesAsDocument(elementInstanceKey, variableNames);
        return variables;
    }

    private void rejectCommand(TypedRecord<JobBatchRecord> record) {
        String rejectionReason;
        RejectionType rejectionType;
        JobBatchRecord value = record.getValue();
        String format = "Expected to activate job batch with %s to be %s, but it was %s";
        if (value.getMaxJobsToActivate() < 1) {
            rejectionType = RejectionType.INVALID_ARGUMENT;
            rejectionReason = String.format("Expected to activate job batch with %s to be %s, but it was %s", "max jobs to activate", "greater than zero", String.format("'%d'", value.getMaxJobsToActivate()));
        } else if (value.getTimeout() < 1L) {
            rejectionType = RejectionType.INVALID_ARGUMENT;
            rejectionReason = String.format("Expected to activate job batch with %s to be %s, but it was %s", "timeout", "greater than zero", String.format("'%d'", value.getTimeout()));
        } else if (value.getTypeBuffer().capacity() < 1) {
            rejectionType = RejectionType.INVALID_ARGUMENT;
            rejectionReason = String.format("Expected to activate job batch with %s to be %s, but it was %s", "type", "present", "blank");
        } else {
            throw new IllegalStateException("Expected to reject an invalid activate job batch command, but it appears to be valid");
        }
        this.rejectionWriter.appendRejection(record, rejectionType, rejectionReason);
        this.responseWriter.writeRejectionOnCommand(record, rejectionType, rejectionReason);
    }

    private void raiseIncidentJobTooLargeForMessageSize(long jobKey, JobRecord job) {
        String messageSize = ByteValue.prettyPrint((long)this.maxRecordLength);
        DirectBuffer incidentMessage = BufferUtil.wrapString((String)String.format("The job with key '%s' can not be activated because it is larger than the configured message size (%s). Try to reduce the size by reducing the number of fetched variables or modifying the variable values.", jobKey, messageSize));
        IncidentRecord incidentEvent = new IncidentRecord().setErrorType(ErrorType.MESSAGE_SIZE_EXCEEDED).setErrorMessage(incidentMessage).setBpmnProcessId(job.getBpmnProcessIdBuffer()).setProcessDefinitionKey(job.getProcessDefinitionKey()).setProcessInstanceKey(job.getProcessInstanceKey()).setElementId(job.getElementIdBuffer()).setElementInstanceKey(job.getElementInstanceKey()).setJobKey(jobKey).setVariableScopeKey(job.getElementInstanceKey());
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)IncidentIntent.CREATED, (RecordValue)incidentEvent);
    }
}

