/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.Error;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import org.agrona.DirectBuffer;

public class ErrorTransformer
implements ModelElementTransformer<Error> {
    @Override
    public Class<Error> getType() {
        return Error.class;
    }

    @Override
    public void transform(Error element, TransformContext context) {
        ExecutableError error = new ExecutableError(element.getId());
        Optional.ofNullable(element.getErrorCode()).map(BufferUtil::wrapString).ifPresent(errorCode -> {
            error.setErrorCode((DirectBuffer)errorCode);
            context.addError(error);
        });
    }
}

