/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

public enum TickerType {
    BLOCK_CACHE_MISS(0),
    BLOCK_CACHE_HIT(1),
    BLOCK_CACHE_ADD(2),
    BLOCK_CACHE_ADD_FAILURES(3),
    BLOCK_CACHE_INDEX_MISS(4),
    BLOCK_CACHE_INDEX_HIT(5),
    BLOCK_CACHE_INDEX_ADD(6),
    BLOCK_CACHE_INDEX_BYTES_INSERT(7),
    BLOCK_CACHE_INDEX_BYTES_EVICT(8),
    BLOCK_CACHE_FILTER_MISS(9),
    BLOCK_CACHE_FILTER_HIT(10),
    BLOCK_CACHE_FILTER_ADD(11),
    BLOCK_CACHE_FILTER_BYTES_INSERT(12),
    BLOCK_CACHE_FILTER_BYTES_EVICT(13),
    BLOCK_CACHE_DATA_MISS(14),
    BLOCK_CACHE_DATA_HIT(15),
    BLOCK_CACHE_DATA_ADD(16),
    BLOCK_CACHE_DATA_BYTES_INSERT(17),
    BLOCK_CACHE_BYTES_READ(18),
    BLOCK_CACHE_BYTES_WRITE(19),
    BLOOM_FILTER_USEFUL(20),
    PERSISTENT_CACHE_HIT(21),
    PERSISTENT_CACHE_MISS(22),
    SIM_BLOCK_CACHE_HIT(23),
    SIM_BLOCK_CACHE_MISS(24),
    MEMTABLE_HIT(25),
    MEMTABLE_MISS(26),
    GET_HIT_L0(27),
    GET_HIT_L1(28),
    GET_HIT_L2_AND_UP(29),
    COMPACTION_KEY_DROP_NEWER_ENTRY(30),
    COMPACTION_KEY_DROP_OBSOLETE(31),
    COMPACTION_KEY_DROP_RANGE_DEL(32),
    COMPACTION_KEY_DROP_USER(33),
    COMPACTION_RANGE_DEL_DROP_OBSOLETE(34),
    NUMBER_KEYS_WRITTEN(35),
    NUMBER_KEYS_READ(36),
    NUMBER_KEYS_UPDATED(37),
    BYTES_WRITTEN(38),
    BYTES_READ(39),
    NUMBER_DB_SEEK(40),
    NUMBER_DB_NEXT(41),
    NUMBER_DB_PREV(42),
    NUMBER_DB_SEEK_FOUND(43),
    NUMBER_DB_NEXT_FOUND(44),
    NUMBER_DB_PREV_FOUND(45),
    ITER_BYTES_READ(46),
    NO_FILE_CLOSES(47),
    NO_FILE_OPENS(48),
    NO_FILE_ERRORS(49),
    STALL_L0_SLOWDOWN_MICROS(50),
    STALL_MEMTABLE_COMPACTION_MICROS(51),
    STALL_L0_NUM_FILES_MICROS(52),
    STALL_MICROS(53),
    DB_MUTEX_WAIT_MICROS(54),
    RATE_LIMIT_DELAY_MILLIS(55),
    NO_ITERATORS(56),
    NUMBER_MULTIGET_CALLS(57),
    NUMBER_MULTIGET_KEYS_READ(58),
    NUMBER_MULTIGET_BYTES_READ(59),
    NUMBER_FILTERED_DELETES(60),
    NUMBER_MERGE_FAILURES(61),
    BLOOM_FILTER_PREFIX_CHECKED(62),
    BLOOM_FILTER_PREFIX_USEFUL(63),
    NUMBER_OF_RESEEKS_IN_ITERATION(64),
    GET_UPDATES_SINCE_CALLS(65),
    BLOCK_CACHE_COMPRESSED_MISS(66),
    BLOCK_CACHE_COMPRESSED_HIT(67),
    BLOCK_CACHE_COMPRESSED_ADD(68),
    BLOCK_CACHE_COMPRESSED_ADD_FAILURES(69),
    WAL_FILE_SYNCED(70),
    WAL_FILE_BYTES(71),
    WRITE_DONE_BY_SELF(72),
    WRITE_DONE_BY_OTHER(73),
    WRITE_TIMEDOUT(74),
    WRITE_WITH_WAL(75),
    COMPACT_READ_BYTES(76),
    COMPACT_WRITE_BYTES(77),
    FLUSH_WRITE_BYTES(78),
    NUMBER_DIRECT_LOAD_TABLE_PROPERTIES(79),
    NUMBER_SUPERVERSION_ACQUIRES(80),
    NUMBER_SUPERVERSION_RELEASES(81),
    NUMBER_SUPERVERSION_CLEANUPS(82),
    NUMBER_BLOCK_COMPRESSED(83),
    NUMBER_BLOCK_DECOMPRESSED(84),
    NUMBER_BLOCK_NOT_COMPRESSED(85),
    MERGE_OPERATION_TOTAL_TIME(86),
    FILTER_OPERATION_TOTAL_TIME(87),
    ROW_CACHE_HIT(88),
    ROW_CACHE_MISS(89),
    READ_AMP_ESTIMATE_USEFUL_BYTES(90),
    READ_AMP_TOTAL_READ_BYTES(91),
    NUMBER_RATE_LIMITER_DRAINS(92),
    NUMBER_ITER_SKIP(93),
    NUMBER_MULTIGET_KEYS_FOUND(94),
    NO_ITERATOR_CREATED(-1),
    NO_ITERATOR_DELETED(96),
    COMPACTION_OPTIMIZED_DEL_DROP_OBSOLETE(97),
    COMPACTION_CANCELLED(98),
    BLOOM_FILTER_FULL_POSITIVE(99),
    BLOOM_FILTER_FULL_TRUE_POSITIVE(100),
    BLOB_DB_NUM_PUT(101),
    BLOB_DB_NUM_WRITE(102),
    BLOB_DB_NUM_GET(103),
    BLOB_DB_NUM_MULTIGET(104),
    BLOB_DB_NUM_SEEK(105),
    BLOB_DB_NUM_NEXT(106),
    BLOB_DB_NUM_PREV(107),
    BLOB_DB_NUM_KEYS_WRITTEN(108),
    BLOB_DB_NUM_KEYS_READ(109),
    BLOB_DB_BYTES_WRITTEN(110),
    BLOB_DB_BYTES_READ(111),
    BLOB_DB_WRITE_INLINED(112),
    BLOB_DB_WRITE_INLINED_TTL(113),
    BLOB_DB_WRITE_BLOB(114),
    BLOB_DB_WRITE_BLOB_TTL(115),
    BLOB_DB_BLOB_FILE_BYTES_WRITTEN(116),
    BLOB_DB_BLOB_FILE_BYTES_READ(117),
    BLOB_DB_BLOB_FILE_SYNCED(118),
    BLOB_DB_BLOB_INDEX_EXPIRED_COUNT(119),
    BLOB_DB_BLOB_INDEX_EXPIRED_SIZE(120),
    BLOB_DB_BLOB_INDEX_EVICTED_COUNT(121),
    BLOB_DB_BLOB_INDEX_EVICTED_SIZE(122),
    BLOB_DB_GC_NUM_FILES(123),
    BLOB_DB_GC_NUM_NEW_FILES(124),
    BLOB_DB_GC_FAILURES(125),
    BLOB_DB_GC_NUM_KEYS_OVERWRITTEN(126),
    BLOB_DB_GC_NUM_KEYS_EXPIRED(127),
    BLOB_DB_GC_NUM_KEYS_RELOCATED(-2),
    BLOB_DB_GC_BYTES_OVERWRITTEN(-3),
    BLOB_DB_GC_BYTES_EXPIRED(-4),
    BLOB_DB_GC_BYTES_RELOCATED(-5),
    BLOB_DB_FIFO_NUM_FILES_EVICTED(-6),
    BLOB_DB_FIFO_NUM_KEYS_EVICTED(-7),
    BLOB_DB_FIFO_BYTES_EVICTED(-8),
    TXN_PREPARE_MUTEX_OVERHEAD(-9),
    TXN_OLD_COMMIT_MAP_MUTEX_OVERHEAD(-10),
    TXN_DUPLICATE_KEY_OVERHEAD(-11),
    TXN_SNAPSHOT_MUTEX_OVERHEAD(-12),
    TXN_GET_TRY_AGAIN(-13),
    FILES_MARKED_TRASH(-14),
    FILES_DELETED_IMMEDIATELY(-15),
    COMPACT_READ_BYTES_MARKED(-16),
    COMPACT_READ_BYTES_PERIODIC(-17),
    COMPACT_READ_BYTES_TTL(-18),
    COMPACT_WRITE_BYTES_MARKED(-19),
    COMPACT_WRITE_BYTES_PERIODIC(-20),
    COMPACT_WRITE_BYTES_TTL(-21),
    ERROR_HANDLER_BG_ERROR_COUNT(-22),
    ERROR_HANDLER_BG_IO_ERROR_COUNT(-23),
    ERROR_HANDLER_BG_RETRYABLE_IO_ERROR_COUNT(-24),
    ERROR_HANDLER_AUTORESUME_COUNT(-25),
    ERROR_HANDLER_AUTORESUME_RETRY_TOTAL_COUNT(-26),
    ERROR_HANDLER_AUTORESUME_SUCCESS_COUNT(-27),
    MEMTABLE_PAYLOAD_BYTES_AT_FLUSH(-28),
    MEMTABLE_GARBAGE_BYTES_AT_FLUSH(-29),
    SECONDARY_CACHE_HITS(-30),
    VERIFY_CHECKSUM_READ_BYTES(-31),
    BACKUP_READ_BYTES(-32),
    BACKUP_WRITE_BYTES(-33),
    REMOTE_COMPACT_READ_BYTES(-34),
    REMOTE_COMPACT_WRITE_BYTES(-35),
    TICKER_ENUM_MAX(95);

    private final byte value;

    private TickerType(byte by) {
        this.value = by;
    }

    public byte getValue() {
        return this.value;
    }

    public static TickerType getTickerType(byte by) {
        for (TickerType tickerType : TickerType.values()) {
            if (tickerType.getValue() != by) continue;
            return tickerType;
        }
        throw new IllegalArgumentException("Illegal value provided for TickerType.");
    }
}

