/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.probes.health;

import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.probes.health.ResponsiveHealthIndicator;
import io.camunda.zeebe.gateway.impl.probes.health.ResponsiveHealthIndicatorProperties;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthContributorAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnEnabledHealthIndicator(value="gateway-responsive")
@AutoConfigureBefore(value={HealthContributorAutoConfiguration.class})
@EnableConfigurationProperties(value={ResponsiveHealthIndicatorProperties.class})
public class ResponsiveHealthIndicatorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"gatewayResponsiveHealthIndicator"})
    public ResponsiveHealthIndicator gatewayResponsiveHealthIndicator(GatewayCfg gatewayCfg, ResponsiveHealthIndicatorProperties properties) {
        return new ResponsiveHealthIndicator(gatewayCfg, properties.getRequestTimeout());
    }
}

