/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.job;

import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.job.LongPollingActivateJobsRequest;
import io.camunda.zeebe.gateway.metrics.LongPollingMetrics;
import java.util.LinkedList;
import java.util.Queue;
import org.slf4j.Logger;

public final class InFlightLongPollingActivateJobsRequestsState {
    private static final Logger LOGGER = Loggers.GATEWAY_LOGGER;
    private final String jobType;
    private final LongPollingMetrics metrics;
    private final Queue<LongPollingActivateJobsRequest> activeRequests = new LinkedList<LongPollingActivateJobsRequest>();
    private final Queue<LongPollingActivateJobsRequest> activeRequestsToBeRepeated = new LinkedList<LongPollingActivateJobsRequest>();
    private final Queue<LongPollingActivateJobsRequest> pendingRequests = new LinkedList<LongPollingActivateJobsRequest>();
    private int failedAttempts;
    private long lastUpdatedTime;

    public InFlightLongPollingActivateJobsRequestsState(String jobType, LongPollingMetrics metrics) {
        this.jobType = jobType;
        this.metrics = metrics;
    }

    public void incrementFailedAttempts(long lastUpdatedTime) {
        ++this.failedAttempts;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setFailedAttempts(int failedAttempts) {
        this.failedAttempts = failedAttempts;
        if (failedAttempts == 0) {
            this.activeRequestsToBeRepeated.addAll(this.activeRequests);
        }
    }

    public void resetFailedAttempts() {
        this.setFailedAttempts(0);
    }

    public int getFailedAttempts() {
        return this.failedAttempts;
    }

    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void enqueueRequest(LongPollingActivateJobsRequest request) {
        if (!this.pendingRequests.contains(request)) {
            this.pendingRequests.offer(request);
        }
        this.removeObsoleteRequestsAndUpdateMetrics();
    }

    public Queue<LongPollingActivateJobsRequest> getPendingRequests() {
        this.removeObsoleteRequestsAndUpdateMetrics();
        return this.pendingRequests;
    }

    private void removeObsoleteRequestsAndUpdateMetrics() {
        this.pendingRequests.removeIf(this::isObsolete);
        this.activeRequests.removeIf(this::isObsolete);
        this.activeRequestsToBeRepeated.removeIf(this::isObsolete);
        this.metrics.setBlockedRequestsCount(this.jobType, this.pendingRequests.size());
    }

    private boolean isObsolete(LongPollingActivateJobsRequest request) {
        return request.isTimedOut() || request.isCanceled() || request.isCompleted();
    }

    public void removeRequest(LongPollingActivateJobsRequest request) {
        this.pendingRequests.remove(request);
        this.removeObsoleteRequestsAndUpdateMetrics();
    }

    public LongPollingActivateJobsRequest getNextPendingRequest() {
        this.removeObsoleteRequestsAndUpdateMetrics();
        LongPollingActivateJobsRequest request = this.pendingRequests.poll();
        this.metrics.setBlockedRequestsCount(this.jobType, this.pendingRequests.size());
        return request;
    }

    public void addActiveRequest(LongPollingActivateJobsRequest request) {
        this.activeRequests.offer(request);
        this.pendingRequests.remove(request);
        this.activeRequestsToBeRepeated.remove(request);
    }

    public void removeActiveRequest(LongPollingActivateJobsRequest request) {
        this.activeRequests.remove(request);
        this.activeRequestsToBeRepeated.remove(request);
    }

    public boolean hasActiveRequests() {
        this.removeObsoleteRequestsAndUpdateMetrics();
        return !this.activeRequests.isEmpty();
    }

    public boolean shouldBeRepeated(LongPollingActivateJobsRequest request) {
        return this.activeRequestsToBeRepeated.contains(request);
    }
}

