/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.configuration;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;

public final class NetworkCfg {
    private String host;
    private int port = 26500;
    private Duration minKeepAliveInterval = Duration.ofSeconds(30L);

    public void init(String defaultHost) {
        if (this.host == null) {
            this.host = defaultHost;
        }
    }

    public String getHost() {
        return this.host;
    }

    public NetworkCfg setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NetworkCfg setPort(int port) {
        this.port = port;
        return this;
    }

    public Duration getMinKeepAliveInterval() {
        return this.minKeepAliveInterval;
    }

    public NetworkCfg setMinKeepAliveInterval(Duration keepAlive) {
        this.minKeepAliveInterval = keepAlive;
        return this;
    }

    public InetSocketAddress toSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkCfg that = (NetworkCfg)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public String toString() {
        return "NetworkCfg{host='" + this.host + "', port=" + this.port + ", minKeepAliveInterval=" + this.minKeepAliveInterval + "}";
    }
}

