/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.gateway.impl.broker.request.BrokerExecuteCommand;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import org.agrona.DirectBuffer;

public final class BrokerActivateJobsRequest
extends BrokerExecuteCommand<JobBatchRecord> {
    private final JobBatchRecord requestDto = new JobBatchRecord();

    public BrokerActivateJobsRequest(String jobType) {
        super(ValueType.JOB_BATCH, (Intent)JobBatchIntent.ACTIVATE);
        this.requestDto.setType(jobType);
    }

    public BrokerActivateJobsRequest setWorker(String worker) {
        this.requestDto.setWorker(worker);
        return this;
    }

    public BrokerActivateJobsRequest setTimeout(long timeout) {
        this.requestDto.setTimeout(timeout);
        return this;
    }

    public BrokerActivateJobsRequest setMaxJobsToActivate(int maxJobsToActivate) {
        this.requestDto.setMaxJobsToActivate(maxJobsToActivate);
        return this;
    }

    public BrokerActivateJobsRequest setVariables(List<String> fetchVariables) {
        ValueArray variables = this.requestDto.variables();
        fetchVariables.stream().map(BufferUtil::wrapString).forEach(buffer -> ((StringValue)variables.add()).wrap(buffer));
        return this;
    }

    public JobBatchRecord getRequestWriter() {
        return this.requestDto;
    }

    @Override
    protected JobBatchRecord toResponseDto(DirectBuffer buffer) {
        JobBatchRecord responseDto = new JobBatchRecord();
        responseDto.wrap(buffer);
        return responseDto;
    }

    public String toString() {
        return "BrokerActivateJobsRequest{requestDto=" + this.requestDto + "}";
    }
}

