/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker;

import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.Subscription;
import io.atomix.utils.event.EventListener;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.BrokerRequestManager;
import io.camunda.zeebe.gateway.impl.broker.BrokerResponseConsumer;
import io.camunda.zeebe.gateway.impl.broker.RoundRobinDispatchStrategy;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyManagerImpl;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerRequest;
import io.camunda.zeebe.gateway.impl.broker.response.BrokerResponse;
import io.camunda.zeebe.gateway.impl.configuration.ClusterCfg;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.transport.ClientTransport;
import io.camunda.zeebe.transport.impl.AtomixClientTransportAdapter;
import io.camunda.zeebe.util.exception.UncheckedExecutionException;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class BrokerClientImpl
implements BrokerClient {
    public static final Logger LOG = Loggers.GATEWAY_LOGGER;
    private static final String ERROR_MSG_STOP_FAILED = "Failed to gracefully shutdown gateway broker client";
    private final ActorScheduler actorScheduler;
    private final BrokerTopologyManagerImpl topologyManager;
    private final boolean ownsActorScheduler;
    private final BrokerRequestManager requestManager;
    private boolean isClosed;
    private Subscription jobAvailableSubscription;
    private final ClusterEventService eventService;

    public BrokerClientImpl(GatewayCfg configuration, MessagingService messagingService, ClusterMembershipService membershipService, ClusterEventService eventService) {
        this(configuration, messagingService, membershipService, eventService, null);
    }

    public BrokerClientImpl(GatewayCfg configuration, MessagingService messagingService, ClusterMembershipService membershipService, ClusterEventService eventService, ActorClock actorClock) {
        this(configuration, messagingService, membershipService, eventService, ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(configuration.getThreads().getManagementThreads()).setIoBoundActorThreadCount(0).setActorClock(actorClock).setSchedulerName("gateway-scheduler").build(), true);
    }

    public BrokerClientImpl(GatewayCfg configuration, MessagingService messagingService, ClusterMembershipService membershipService, ClusterEventService eventService, ActorScheduler actorScheduler, boolean ownsActorScheduler) {
        this.eventService = eventService;
        this.actorScheduler = actorScheduler;
        this.ownsActorScheduler = ownsActorScheduler;
        if (ownsActorScheduler) {
            actorScheduler.start();
        }
        ClusterCfg clusterCfg = configuration.getCluster();
        this.topologyManager = new BrokerTopologyManagerImpl(() -> ((ClusterMembershipService)membershipService).getMembers());
        actorScheduler.submitActor((Actor)this.topologyManager);
        membershipService.addListener((EventListener)this.topologyManager);
        membershipService.getMembers().forEach(member -> this.topologyManager.event(new ClusterMembershipEvent(ClusterMembershipEvent.Type.MEMBER_ADDED, member)));
        AtomixClientTransportAdapter atomixTransportAdapter = new AtomixClientTransportAdapter(messagingService);
        actorScheduler.submitActor((Actor)atomixTransportAdapter);
        this.requestManager = new BrokerRequestManager((ClientTransport)atomixTransportAdapter, this.topologyManager, new RoundRobinDispatchStrategy(this.topologyManager), clusterCfg.getRequestTimeout());
        actorScheduler.submitActor((Actor)this.requestManager);
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        LOG.debug("Closing gateway broker client ...");
        this.doAndLogException(() -> ((BrokerTopologyManagerImpl)this.topologyManager).close());
        LOG.debug("topology manager closed");
        if (this.jobAvailableSubscription != null) {
            this.jobAvailableSubscription.close();
        }
        if (this.ownsActorScheduler) {
            try {
                this.actorScheduler.stop().get(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new UncheckedExecutionException(ERROR_MSG_STOP_FAILED, (Throwable)ie);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new UncheckedExecutionException(ERROR_MSG_STOP_FAILED, (Throwable)e);
            }
        }
        LOG.debug("Gateway broker client closed.");
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequest(BrokerRequest<T> request) {
        return this.requestManager.sendRequest(request);
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequest(BrokerRequest<T> request, Duration requestTimeout) {
        return this.requestManager.sendRequest(request, requestTimeout);
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequestWithRetry(BrokerRequest<T> request) {
        return this.requestManager.sendRequestWithRetry(request);
    }

    @Override
    public <T> CompletableFuture<BrokerResponse<T>> sendRequestWithRetry(BrokerRequest<T> request, Duration requestTimeout) {
        return this.requestManager.sendRequestWithRetry(request, requestTimeout);
    }

    @Override
    public <T> void sendRequestWithRetry(BrokerRequest<T> request, BrokerResponseConsumer<T> responseConsumer, Consumer<Throwable> throwableConsumer) {
        this.requestManager.sendRequestWithRetry(request).whenComplete((response, error) -> {
            if (error == null) {
                responseConsumer.accept(response.getKey(), response.getResponse());
            } else {
                throwableConsumer.accept((Throwable)error);
            }
        });
    }

    @Override
    public BrokerTopologyManager getTopologyManager() {
        return this.topologyManager;
    }

    @Override
    public void subscribeJobAvailableNotification(String topic, Consumer<String> handler) {
        this.jobAvailableSubscription = (Subscription)this.eventService.subscribe(topic, msg -> {
            handler.accept((String)msg);
            return CompletableFuture.completedFuture(null);
        }).join();
    }

    private void doAndLogException(Runnable r) {
        try {
            r.run();
        }
        catch (Exception e) {
            LOG.error("Exception when closing client. Ignoring", (Throwable)e);
        }
    }
}

