/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport;

import io.atomix.cluster.messaging.MessagingService;
import io.camunda.zeebe.transport.ClientTransport;
import io.camunda.zeebe.transport.ServerTransport;
import io.camunda.zeebe.transport.impl.AtomixClientTransportAdapter;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorSchedulingService;

public final class TransportFactory {
    private final ActorSchedulingService actorSchedulingService;

    public TransportFactory(ActorSchedulingService actorSchedulingService) {
        this.actorSchedulingService = actorSchedulingService;
    }

    public ServerTransport createServerTransport(int nodeId, MessagingService messagingService) {
        AtomixServerTransport atomixServerTransport = new AtomixServerTransport(nodeId, messagingService);
        this.actorSchedulingService.submitActor((Actor)atomixServerTransport);
        return atomixServerTransport;
    }

    public ClientTransport createClientTransport(MessagingService messagingService) {
        AtomixClientTransportAdapter atomixClientTransportAdapter = new AtomixClientTransportAdapter(messagingService);
        this.actorSchedulingService.submitActor((Actor)atomixClientTransportAdapter);
        return atomixClientTransportAdapter;
    }
}

