/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.storage.atomix;

import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.camunda.zeebe.logstreams.storage.LogStorageReader;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class AtomixLogStorageReader
implements LogStorageReader {
    private final RaftLogReader reader;
    private final DirectBuffer currentBlockBuffer;
    private final DirectBuffer nextBlockBuffer;

    public AtomixLogStorageReader(RaftLogReader reader) {
        this.reader = reader;
        this.currentBlockBuffer = new UnsafeBuffer();
        this.nextBlockBuffer = new UnsafeBuffer();
        this.reset();
    }

    @Override
    public void seek(long position) {
        long boundedPosition = Math.max(0L, position);
        this.reader.seekToAsqn(boundedPosition);
        this.reset();
        this.readNextBlock();
    }

    @Override
    public void close() {
        this.reset();
        this.reader.close();
    }

    @Override
    public boolean hasNext() {
        return this.hasNextBlock() || this.readNextBlock();
    }

    @Override
    public DirectBuffer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentBlockBuffer.wrap(this.nextBlockBuffer);
        this.nextBlockBuffer.wrap(0L, 0);
        return this.currentBlockBuffer;
    }

    private boolean hasNextBlock() {
        return this.nextBlockBuffer.addressOffset() != 0L;
    }

    private boolean readNextBlock() {
        while (this.reader.hasNext()) {
            IndexedRaftLogEntry entry = (IndexedRaftLogEntry)this.reader.next();
            if (!entry.isApplicationEntry()) continue;
            ApplicationEntry nextEntry = entry.getApplicationEntry();
            this.nextBlockBuffer.wrap(nextEntry.data());
            return true;
        }
        return false;
    }

    private void reset() {
        this.currentBlockBuffer.wrap(0L, 0);
        this.nextBlockBuffer.wrap(0L, 0);
    }
}

