/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.logstreams.impl.log.LoggedEventImpl;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.logstreams.storage.LogStorageReader;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class LogStreamReaderImpl
implements LogStreamReader {
    private final LogStorageReader reader;
    private final LoggedEventImpl currentEvent;
    private final DirectBuffer currentEventBuffer;
    private final LoggedEventImpl nextEvent;
    private final DirectBuffer nextEventBuffer;
    private int nextEventOffset;

    public LogStreamReaderImpl(LogStorageReader reader) {
        this.reader = reader;
        this.currentEvent = new LoggedEventImpl();
        this.currentEventBuffer = new UnsafeBuffer();
        this.nextEvent = new LoggedEventImpl();
        this.nextEventBuffer = new UnsafeBuffer();
        this.reset();
        this.seekToFirstEvent();
    }

    @Override
    public boolean hasNext() {
        return this.hasBufferedEvents() || this.readNextBlock();
    }

    @Override
    public LoggedEvent next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentEventBuffer.wrap(this.nextEventBuffer, this.nextEvent.getFragmentOffset(), this.nextEvent.getFragmentLength());
        this.nextEventOffset += this.nextEvent.getLength();
        this.nextEvent.wrap(this.nextEventBuffer, this.nextEventOffset);
        return this.currentEvent;
    }

    @Override
    public boolean seekToNextEvent(long position) {
        if (position < 0L) {
            this.seekToFirstEvent();
            return true;
        }
        long nextPosition = position + 1L;
        this.seek(nextPosition);
        return this.getNextEventPosition() == nextPosition || this.getCurrentPosition() == position;
    }

    @Override
    public boolean seek(long position) {
        this.reader.seek(position);
        this.reset();
        this.readNextBlock();
        while (this.hasNext() && this.getNextEventPosition() < position) {
            this.next();
        }
        return this.getNextEventPosition() == position;
    }

    @Override
    public void seekToFirstEvent() {
        this.seek(Long.MIN_VALUE);
    }

    @Override
    public long seekToEnd() {
        this.seek(Long.MAX_VALUE);
        while (this.hasNext()) {
            this.next();
        }
        return this.getPosition();
    }

    @Override
    public long getPosition() {
        long currentPosition = this.getCurrentPosition();
        if (currentPosition > -1L) {
            return currentPosition;
        }
        return this.getNextEventPosition();
    }

    public void close() {
        this.reset();
        this.reader.close();
    }

    private long getCurrentPosition() {
        if (this.isEventBufferValid(this.currentEventBuffer)) {
            return this.currentEvent.getPosition();
        }
        return -1L;
    }

    private long getNextEventPosition() {
        if (this.hasBufferedEvents()) {
            return this.nextEvent.getPosition();
        }
        return -1L;
    }

    @Override
    public LoggedEvent peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextEvent;
    }

    private void reset() {
        this.currentEventBuffer.wrap(0L, 0);
        this.currentEvent.wrap(this.currentEventBuffer, 0);
        this.nextEventBuffer.wrap(0L, 0);
        this.nextEvent.wrap(this.nextEventBuffer, 0);
        this.nextEventOffset = 0;
    }

    private boolean hasBufferedEvents() {
        return this.isEventBufferValid(this.nextEventBuffer) && this.nextEventOffset < this.nextEventBuffer.capacity();
    }

    private boolean readNextBlock() {
        if (!this.reader.hasNext()) {
            return false;
        }
        DirectBuffer nextBlock = (DirectBuffer)this.reader.next();
        this.nextEventBuffer.wrap(nextBlock);
        this.nextEventOffset = 0;
        this.nextEvent.wrap(this.nextEventBuffer, this.nextEventOffset);
        return true;
    }

    private boolean isEventBufferValid(DirectBuffer eventBuffer) {
        return eventBuffer.addressOffset() != 0L;
    }
}

