/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.dispatcher.ClaimedFragmentBatch;
import io.camunda.zeebe.dispatcher.Dispatcher;
import io.camunda.zeebe.logstreams.impl.log.LogEntryDescriptor;
import io.camunda.zeebe.logstreams.log.LogStreamBatchWriter;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.util.EnsureUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.camunda.zeebe.util.buffer.DirectBufferWriter;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;

public final class LogStreamBatchWriterImpl
implements LogStreamBatchWriter,
LogStreamBatchWriter.LogEntryBuilder {
    private static final int INITIAL_BUFFER_CAPACITY = 32768;
    private final ClaimedFragmentBatch claimedBatch = new ClaimedFragmentBatch();
    private final MutableDirectBuffer eventBuffer = new ExpandableDirectByteBuffer(32768);
    private final DirectBufferWriter metadataWriterInstance = new DirectBufferWriter();
    private final DirectBufferWriter bufferWriterInstance = new DirectBufferWriter();
    private int eventBufferOffset;
    private int eventLength;
    private int eventCount;
    private final Dispatcher logWriteBuffer;
    private final int logId;
    private long key;
    private long sourceEventPosition;
    private int sourceIndex;
    private BufferWriter metadataWriter;
    private BufferWriter valueWriter;

    LogStreamBatchWriterImpl(int partitionId, Dispatcher dispatcher) {
        this.logWriteBuffer = dispatcher;
        this.logId = partitionId;
        this.reset();
    }

    @Override
    public LogStreamBatchWriter sourceRecordPosition(long position) {
        this.sourceEventPosition = position;
        return this;
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder event() {
        this.copyExistingEventToBuffer();
        this.resetEvent();
        return this;
    }

    @Override
    public int getMaxFragmentLength() {
        return this.logWriteBuffer.getMaxFragmentLength();
    }

    @Override
    public void reset() {
        this.eventBufferOffset = 0;
        this.eventLength = 0;
        this.eventCount = 0;
        this.sourceEventPosition = -1L;
        this.resetEvent();
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder keyNull() {
        return this.key(-1L);
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder key(long key) {
        this.key = key;
        return this;
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder sourceIndex(int index) {
        this.sourceIndex = index;
        return this;
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder metadata(DirectBuffer buffer, int offset, int length) {
        this.metadataWriterInstance.wrap(buffer, offset, length);
        return this;
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder metadata(DirectBuffer buffer) {
        return this.metadata(buffer, 0, buffer.capacity());
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder metadataWriter(BufferWriter writer) {
        this.metadataWriter = writer;
        return this;
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder value(DirectBuffer value, int valueOffset, int valueLength) {
        return this.valueWriter((BufferWriter)this.bufferWriterInstance.wrap(value, valueOffset, valueLength));
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder value(DirectBuffer value) {
        return this.value(value, 0, value.capacity());
    }

    @Override
    public LogStreamBatchWriter.LogEntryBuilder valueWriter(BufferWriter writer) {
        this.valueWriter = writer;
        return this;
    }

    @Override
    public LogStreamBatchWriter done() {
        EnsureUtil.ensureNotNull((String)"value", (Object)this.valueWriter);
        this.copyExistingEventToBuffer();
        this.resetEvent();
        return this;
    }

    public void copyExistingEventToBuffer() {
        if (this.valueWriter == null) {
            return;
        }
        int metadataLength = this.metadataWriter.getLength();
        int valueLength = this.valueWriter.getLength();
        this.eventBuffer.putLong(this.eventBufferOffset, this.key, Protocol.ENDIANNESS);
        this.eventBufferOffset += 8;
        this.eventBuffer.putInt(this.eventBufferOffset, this.sourceIndex, Protocol.ENDIANNESS);
        this.eventBufferOffset += 4;
        this.eventBuffer.putInt(this.eventBufferOffset, metadataLength, Protocol.ENDIANNESS);
        this.eventBufferOffset += 4;
        this.eventBuffer.putInt(this.eventBufferOffset, valueLength, Protocol.ENDIANNESS);
        this.eventBufferOffset += 4;
        if (metadataLength > 0) {
            this.metadataWriter.write(this.eventBuffer, this.eventBufferOffset);
            this.eventBufferOffset += metadataLength;
        }
        this.valueWriter.write(this.eventBuffer, this.eventBufferOffset);
        this.eventBufferOffset += valueLength;
        this.eventLength += metadataLength + valueLength;
        ++this.eventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long tryWrite() {
        long position;
        if (this.eventCount == 0) {
            if (this.valueWriter == null) {
                return 0L;
            }
            this.copyExistingEventToBuffer();
        }
        if ((position = this.claimBatchForEvents()) >= 0L) {
            try {
                this.writeEventsToBuffer(this.claimedBatch.getBuffer(), position);
                position += (long)(this.eventCount - 1);
                this.claimedBatch.commit();
            }
            catch (Exception e) {
                this.claimedBatch.abort();
                LangUtil.rethrowUnchecked((Throwable)e);
            }
            finally {
                this.reset();
            }
        }
        return position;
    }

    private long claimBatchForEvents() {
        long claimedPosition;
        int batchLength = this.eventLength + this.eventCount * LogEntryDescriptor.HEADER_BLOCK_LENGTH;
        while ((claimedPosition = this.logWriteBuffer.claimFragmentBatch(this.claimedBatch, this.eventCount, batchLength)) == -2L) {
        }
        return claimedPosition;
    }

    private void writeEventsToBuffer(MutableDirectBuffer writeBuffer, long firstPosition) {
        this.eventBufferOffset = 0;
        for (int i = 0; i < this.eventCount; ++i) {
            long key = this.eventBuffer.getLong(this.eventBufferOffset, Protocol.ENDIANNESS);
            this.eventBufferOffset += 8;
            int sourceIndex = this.eventBuffer.getInt(this.eventBufferOffset, Protocol.ENDIANNESS);
            this.eventBufferOffset += 4;
            int metadataLength = this.eventBuffer.getInt(this.eventBufferOffset, Protocol.ENDIANNESS);
            this.eventBufferOffset += 4;
            int valueLength = this.eventBuffer.getInt(this.eventBufferOffset, Protocol.ENDIANNESS);
            this.eventBufferOffset += 4;
            int fragmentLength = LogEntryDescriptor.headerLength(metadataLength) + valueLength;
            this.claimedBatch.nextFragment(fragmentLength, this.logId);
            int bufferOffset = this.claimedBatch.getFragmentOffset();
            LogEntryDescriptor.setPosition(writeBuffer, bufferOffset, firstPosition + (long)i);
            if (sourceIndex >= 0 && sourceIndex < i) {
                LogEntryDescriptor.setSourceEventPosition(writeBuffer, bufferOffset, firstPosition + (long)sourceIndex);
            } else {
                LogEntryDescriptor.setSourceEventPosition(writeBuffer, bufferOffset, this.sourceEventPosition);
            }
            LogEntryDescriptor.setKey(writeBuffer, bufferOffset, key);
            LogEntryDescriptor.setTimestamp(writeBuffer, bufferOffset, ActorClock.currentTimeMillis());
            LogEntryDescriptor.setMetadataLength(writeBuffer, bufferOffset, (short)metadataLength);
            if (metadataLength > 0) {
                writeBuffer.putBytes(LogEntryDescriptor.metadataOffset(bufferOffset), (DirectBuffer)this.eventBuffer, this.eventBufferOffset, metadataLength);
                this.eventBufferOffset += metadataLength;
            }
            writeBuffer.putBytes(LogEntryDescriptor.valueOffset(bufferOffset, metadataLength), (DirectBuffer)this.eventBuffer, this.eventBufferOffset, valueLength);
            this.eventBufferOffset += valueLength;
        }
    }

    private void resetEvent() {
        this.key = -1L;
        this.sourceIndex = -1;
        this.metadataWriter = this.metadataWriterInstance;
        this.valueWriter = null;
        this.bufferWriterInstance.reset();
        this.metadataWriterInstance.reset();
    }
}

