/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorMode;
import io.camunda.zeebe.engine.state.appliers.EventAppliers;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.function.BiFunction;

public final class StreamProcessorTransitionStep
implements PartitionTransitionStep {
    private final BiFunction<PartitionTransitionContext, RaftServer.Role, StreamProcessor> streamProcessorCreator;

    public StreamProcessorTransitionStep() {
        this(StreamProcessorTransitionStep::createStreamProcessor);
    }

    public StreamProcessorTransitionStep(BiFunction<PartitionTransitionContext, RaftServer.Role, StreamProcessor> streamProcessorCreator) {
        this.streamProcessorCreator = streamProcessorCreator;
    }

    @Override
    public void onNewRaftRole(PartitionTransitionContext context, RaftServer.Role newRole) {
        RaftServer.Role currentRole = context.getCurrentRole();
        StreamProcessor streamprocessor = context.getStreamProcessor();
        if (streamprocessor == null) {
            return;
        }
        if (this.shouldInstallOnTransition(newRole, currentRole) || newRole == RaftServer.Role.INACTIVE) {
            streamprocessor.pauseProcessing();
        }
    }

    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        ConcurrencyControl concurrencyControl = context.getConcurrencyControl();
        RaftServer.Role currentRole = context.getCurrentRole();
        StreamProcessor streamprocessor = context.getStreamProcessor();
        if (streamprocessor != null && (this.shouldInstallOnTransition(targetRole, currentRole) || targetRole == RaftServer.Role.INACTIVE)) {
            context.getComponentHealthMonitor().removeComponent(streamprocessor.getName());
            ActorFuture future = streamprocessor.closeAsync();
            future.onComplete((success, error) -> {
                if (error == null) {
                    context.setStreamProcessor(null);
                }
            });
            return future;
        }
        return concurrencyControl.createCompletedFuture();
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        RaftServer.Role currentRole = context.getCurrentRole();
        ConcurrencyControl concurrencyControl = context.getConcurrencyControl();
        if (this.shouldInstallOnTransition(targetRole, currentRole) || context.getStreamProcessor() == null && targetRole != RaftServer.Role.INACTIVE) {
            StreamProcessor streamProcessor = this.streamProcessorCreator.apply(context, targetRole);
            context.setStreamProcessor(streamProcessor);
            ActorFuture openFuture = streamProcessor.openAsync(!context.shouldProcess());
            ActorFuture future = concurrencyControl.createFuture();
            openFuture.onComplete((nothing, err) -> {
                if (err == null) {
                    if (!context.shouldProcess()) {
                        streamProcessor.pauseProcessing();
                    } else {
                        streamProcessor.resumeProcessing();
                    }
                    context.getComponentHealthMonitor().registerComponent(streamProcessor.getName(), (HealthMonitorable)streamProcessor);
                    future.complete(null);
                } else {
                    future.completeExceptionally(err);
                }
            });
            return future;
        }
        return concurrencyControl.createCompletedFuture();
    }

    @Override
    public String getName() {
        return "StreamProcessor";
    }

    private boolean shouldInstallOnTransition(RaftServer.Role newRole, RaftServer.Role currentRole) {
        return newRole == RaftServer.Role.LEADER || newRole == RaftServer.Role.FOLLOWER && currentRole != RaftServer.Role.CANDIDATE || newRole == RaftServer.Role.CANDIDATE && currentRole != RaftServer.Role.FOLLOWER;
    }

    private static StreamProcessor createStreamProcessor(PartitionTransitionContext context, RaftServer.Role targetRole) {
        StreamProcessorMode streamProcessorMode = targetRole == RaftServer.Role.LEADER ? StreamProcessorMode.PROCESSING : StreamProcessorMode.REPLAY;
        return StreamProcessor.builder().logStream(context.getLogStream()).actorSchedulingService(context.getActorSchedulingService()).zeebeDb(context.getZeebeDb()).eventApplierFactory(EventAppliers::new).nodeId(context.getNodeId()).commandResponseWriter(context.getCommandResponseWriter()).listener(processedCommand -> context.getOnProcessedListener().accept(processedCommand)).streamProcessorFactory(context.getStreamProcessorFactory()).streamProcessorMode(streamProcessorMode).build();
    }
}

