/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftCommittedEntryListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.AsyncSnapshotDirector;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.time.Duration;

public final class SnapshotDirectorPartitionTransitionStep
implements PartitionTransitionStep {
    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        AsyncSnapshotDirector snapshotDirector = context.getSnapshotDirector();
        if (snapshotDirector != null && (this.shouldInstallOnTransition(targetRole, context.getCurrentRole()) || targetRole == RaftServer.Role.INACTIVE)) {
            AsyncSnapshotDirector director = context.getSnapshotDirector();
            context.getComponentHealthMonitor().removeComponent(director.getName());
            context.getRaftPartition().getServer().removeCommittedEntryListener((RaftCommittedEntryListener)director);
            ActorFuture<Void> future = director.closeAsync();
            future.onComplete((ok, error) -> {
                if (error == null) {
                    context.setSnapshotDirector(null);
                }
            });
            return future;
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        if (context.getSnapshotDirector() == null && targetRole != RaftServer.Role.INACTIVE || this.shouldInstallOnTransition(targetRole, context.getCurrentRole())) {
            RaftPartitionServer server = context.getRaftPartition().getServer();
            Duration snapshotPeriod = context.getBrokerCfg().getData().getSnapshotPeriod();
            AsyncSnapshotDirector director = targetRole == RaftServer.Role.LEADER ? AsyncSnapshotDirector.ofProcessingMode(context.getNodeId(), context.getPartitionId(), context.getStreamProcessor(), context.getStateController(), snapshotPeriod) : AsyncSnapshotDirector.ofReplayMode(context.getNodeId(), context.getPartitionId(), context.getStreamProcessor(), context.getStateController(), snapshotPeriod);
            ActorFuture future = context.getActorSchedulingService().submitActor((Actor)director);
            future.onComplete((ok, error) -> {
                if (error == null) {
                    context.setSnapshotDirector(director);
                    context.getComponentHealthMonitor().registerComponent(director.getName(), (HealthMonitorable)director);
                    if (targetRole == RaftServer.Role.LEADER) {
                        server.addCommittedEntryListener((RaftCommittedEntryListener)director);
                    }
                }
            });
            return future;
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "SnapshotDirector";
    }

    private boolean shouldInstallOnTransition(RaftServer.Role newRole, RaftServer.Role currentRole) {
        return newRole == RaftServer.Role.LEADER || newRole == RaftServer.Role.FOLLOWER && currentRole != RaftServer.Role.CANDIDATE || newRole == RaftServer.Role.CANDIDATE && currentRole != RaftServer.Role.FOLLOWER;
    }
}

