/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.storage.atomix.AtomixLogStorage;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.util.function.Supplier;

public final class LogStreamPartitionTransitionStep
implements PartitionTransitionStep {
    private final Supplier<LogStreamBuilder> logStreamBuilderSupplier;

    public LogStreamPartitionTransitionStep() {
        this(LogStream::builder);
    }

    LogStreamPartitionTransitionStep(Supplier<LogStreamBuilder> logStreamBuilderSupplier) {
        this.logStreamBuilderSupplier = logStreamBuilderSupplier;
    }

    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        LogStream logStream = context.getLogStream();
        if (logStream != null && (this.shouldInstallOnTransition(targetRole, context.getCurrentRole()) || targetRole == RaftServer.Role.INACTIVE)) {
            context.getComponentHealthMonitor().removeComponent(logStream.getLogName());
            ActorFuture future = logStream.closeAsync();
            future.onComplete((ok, error) -> {
                if (error == null) {
                    context.setLogStream(null);
                }
            });
            return future;
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        if (context.getLogStream() == null && targetRole != RaftServer.Role.INACTIVE || this.shouldInstallOnTransition(targetRole, context.getCurrentRole())) {
            CompletableActorFuture openFuture = new CompletableActorFuture();
            AtomixLogStorage logStorage = context.getLogStorage();
            this.buildLogstream(context, logStorage).onComplete((logStream, err) -> {
                if (err == null) {
                    context.setLogStream((LogStream)logStream);
                    context.getComponentHealthMonitor().registerComponent(logStream.getLogName(), (HealthMonitorable)logStream);
                    openFuture.complete(null);
                } else {
                    openFuture.completeExceptionally(err);
                }
            });
            return openFuture;
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "LogStream";
    }

    private ActorFuture<LogStream> buildLogstream(PartitionTransitionContext context, AtomixLogStorage atomixLogStorage) {
        return this.logStreamBuilderSupplier.get().withLogStorage((LogStorage)atomixLogStorage).withLogName("logstream-" + context.getRaftPartition().name()).withNodeId(context.getNodeId()).withPartitionId(context.getPartitionId()).withMaxFragmentSize(context.getMaxFragmentSize()).withActorSchedulingService(context.getActorSchedulingService()).buildAsync();
    }

    private boolean shouldInstallOnTransition(RaftServer.Role newRole, RaftServer.Role currentRole) {
        return newRole == RaftServer.Role.LEADER || newRole == RaftServer.Role.FOLLOWER && currentRole != RaftServer.Role.CANDIDATE || newRole == RaftServer.Role.CANDIDATE && currentRole != RaftServer.Role.FOLLOWER;
    }
}

