/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;

final class PartitionTransitionProcess {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final List<PartitionTransitionStep> pendingSteps;
    private final Deque<PartitionTransitionStep> stepsToPrepare = new ArrayDeque<PartitionTransitionStep>();
    private final ConcurrencyControl concurrencyControl;
    private final PartitionTransitionContext context;
    private final long term;
    private final RaftServer.Role role;
    private boolean cancelRequested = false;

    PartitionTransitionProcess(List<PartitionTransitionStep> pendingSteps, ConcurrencyControl concurrencyControl, PartitionTransitionContext context, long term, RaftServer.Role role) {
        this.pendingSteps = new ArrayList<PartitionTransitionStep>((Collection)Objects.requireNonNull(pendingSteps));
        pendingSteps.forEach(this.stepsToPrepare::push);
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
        this.context = Objects.requireNonNull(context);
        context.setConcurrencyControl(concurrencyControl);
        this.term = term;
        this.role = Objects.requireNonNull(role);
    }

    void start(ActorFuture<Void> future) {
        LOG.info("Transition to {} on term {} starting", (Object)this.role, (Object)this.term);
        if (this.pendingSteps.isEmpty()) {
            LOG.info("No steps defined for transition");
            future.complete(null);
            return;
        }
        this.proceedWithTransition(future);
    }

    private void proceedWithTransition(ActorFuture<Void> future) {
        if (this.cancelRequested) {
            LOG.info("Cancelling transition to {} on term {}", (Object)this.role, (Object)this.term);
            future.complete(null);
            return;
        }
        this.concurrencyControl.run(() -> {
            PartitionTransitionStep nextStep = this.pendingSteps.remove(0);
            LOG.info("Transition to {} on term {} - transitioning {}", new Object[]{this.role, this.term, nextStep.getName()});
            nextStep.transitionTo(this.context, this.term, this.role).onComplete((ok, error) -> this.onStepCompletion(future, (Throwable)error));
        });
    }

    private void onStepCompletion(ActorFuture<Void> future, Throwable error) {
        if (error != null) {
            LOG.error(error.getMessage(), error);
            future.completeExceptionally(error);
            return;
        }
        if (this.pendingSteps.isEmpty()) {
            LOG.info("Transition to {} on term {} completed", (Object)this.role, (Object)this.term);
            future.complete(null);
            return;
        }
        this.proceedWithTransition(future);
    }

    ActorFuture<Void> prepare(long newTerm, RaftServer.Role newRole) {
        LOG.info("Prepare transition from {} on term {} to {}", new Object[]{this.role, this.term, newRole});
        ActorFuture prepareFuture = this.concurrencyControl.createFuture();
        if (this.stepsToPrepare.isEmpty()) {
            LOG.info("No steps to prepare transition");
            prepareFuture.complete(null);
        } else {
            this.proceedWithPrepare((ActorFuture<Void>)prepareFuture, newTerm, newRole);
        }
        return prepareFuture;
    }

    private void proceedWithPrepare(ActorFuture<Void> future, long newTerm, RaftServer.Role newRole) {
        this.concurrencyControl.run(() -> {
            PartitionTransitionStep nextPrepareStep = this.stepsToPrepare.pop();
            LOG.info("Prepare transition from {} on term {} to {} - preparing {}", new Object[]{this.role, this.term, newRole, nextPrepareStep.getName()});
            nextPrepareStep.prepareTransition(this.context, newTerm, newRole).onComplete((ok, error) -> this.onPrepareStepCompletion(future, (Throwable)error, newTerm, newRole));
        });
    }

    private void onPrepareStepCompletion(ActorFuture<Void> future, Throwable error, long newTerm, RaftServer.Role newRole) {
        if (error != null) {
            LOG.error(error.getMessage(), error);
            future.completeExceptionally(error);
            return;
        }
        if (this.stepsToPrepare.isEmpty()) {
            LOG.info("Preparing transition from {} on term {} completed", (Object)this.role, (Object)this.term);
            future.complete(null);
            return;
        }
        this.proceedWithPrepare(future, newTerm, newRole);
    }

    void cancel() {
        LOG.info("Received cancel signal for transition to {} on term {}", (Object)this.role, (Object)this.term);
        this.cancelRequested = true;
    }
}

