/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.partitions.PartitionTransition;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionTransitionProcess;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;

public final class PartitionTransitionImpl
implements PartitionTransition {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final List<PartitionTransitionStep> steps;
    private PartitionTransitionContext context;
    private ConcurrencyControl concurrencyControl;
    private PartitionTransitionProcess lastTransition;
    private PartitionTransitionProcess currentTransition;
    private ActorFuture<Void> currentTransitionFuture;

    public PartitionTransitionImpl(List<PartitionTransitionStep> steps) {
        this.steps = new ArrayList<PartitionTransitionStep>((Collection)Objects.requireNonNull(steps));
    }

    @Override
    public ActorFuture<Void> toFollower(long term) {
        return this.transitionTo(term, RaftServer.Role.FOLLOWER);
    }

    @Override
    public ActorFuture<Void> toLeader(long term) {
        return this.transitionTo(term, RaftServer.Role.LEADER);
    }

    @Override
    public ActorFuture<Void> toInactive(long term) {
        return this.transitionTo(term, RaftServer.Role.INACTIVE);
    }

    @Override
    public void setConcurrencyControl(ConcurrencyControl concurrencyControl) {
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
    }

    @Override
    public void updateTransitionContext(PartitionTransitionContext transitionContext) {
        this.context = transitionContext;
    }

    public ActorFuture<Void> transitionTo(long term, RaftServer.Role role) {
        LOG.info("Transition to {} on term {} requested.", (Object)role, (Object)term);
        this.steps.forEach(step -> step.onNewRaftRole(this.context, role));
        ActorFuture nextTransitionFuture = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            PartitionTransitionProcess nextTransition = new PartitionTransitionProcess(this.steps, this.concurrencyControl, this.context, term, role);
            nextTransitionFuture.onComplete((v, error) -> {
                if (error == null) {
                    this.context.setCurrentTerm(term);
                    this.context.setCurrentRole(role);
                }
                this.lastTransition = nextTransition;
            });
            this.enqueueNextTransition(term, role, (ActorFuture<Void>)nextTransitionFuture, nextTransition);
        });
        return nextTransitionFuture;
    }

    private void enqueueNextTransition(long term, RaftServer.Role role, ActorFuture<Void> nextTransitionFuture, PartitionTransitionProcess nextTransition) {
        ActorFuture ongoingTransitionFuture;
        if (this.currentTransition == null) {
            ongoingTransitionFuture = this.concurrencyControl.createCompletedFuture();
        } else {
            ongoingTransitionFuture = this.currentTransitionFuture;
            PartitionTransitionProcess ongoingTransition = this.currentTransition;
            ongoingTransition.cancel();
        }
        this.currentTransitionFuture = nextTransitionFuture;
        this.currentTransition = nextTransition;
        ongoingTransitionFuture.onComplete((nothing, error) -> this.performNextTransition(term, role, nextTransitionFuture, nextTransition));
    }

    private void performNextTransition(long term, RaftServer.Role role, ActorFuture<Void> nextTransitionFuture, PartitionTransitionProcess nextTransition) {
        if (this.lastTransition == null) {
            nextTransition.start(nextTransitionFuture);
        } else {
            ActorFuture<Void> prepareFuture = nextTransition.prepare(term, role);
            prepareFuture.onComplete((ok, error) -> {
                if (error != null) {
                    LOG.error("Error during transition preparation: {}", (Object)error.getMessage(), error);
                    LOG.info("Aborting transition to {} on term {} due to error.", (Object)role, (Object)term);
                    nextTransitionFuture.completeExceptionally(error);
                } else {
                    nextTransition.start(nextTransitionFuture);
                }
            });
        }
    }
}

