/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLogReader;
import io.camunda.zeebe.broker.system.partitions.AtomixRecordEntrySupplier;
import java.util.Optional;

public final class AtomixRecordEntrySupplierImpl
implements AtomixRecordEntrySupplier {
    private final RaftPartitionServer raftPartitionServer;

    public AtomixRecordEntrySupplierImpl(RaftPartitionServer raftPartitionServer) {
        this.raftPartitionServer = raftPartitionServer;
    }

    @Override
    public Optional<IndexedRaftLogEntry> getPreviousIndexedEntry(long position) {
        try (RaftLogReader reader = this.raftPartitionServer.openReader();){
            long recordIndex = reader.seekToAsqn(position);
            long prevIndex = recordIndex - 1L;
            if (reader.seek(prevIndex) == prevIndex) {
                Optional<IndexedRaftLogEntry> optional = Optional.of((IndexedRaftLogEntry)reader.next());
                return optional;
            }
            Optional<IndexedRaftLogEntry> optional = Optional.empty();
            return optional;
        }
    }
}

