/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.partitioning.PartitionAdminAccess;
import io.camunda.zeebe.broker.system.partitions.PartitionAdminControl;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.io.IOException;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

class ZeebePartitionAdminAccess
implements PartitionAdminAccess {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final ConcurrencyControl concurrencyControl;
    private final PartitionAdminControl adminControl;

    ZeebePartitionAdminAccess(ConcurrencyControl concurrencyControl, PartitionAdminControl adminControl) {
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
        this.adminControl = Objects.requireNonNull(adminControl);
    }

    @Override
    public ActorFuture<Void> takeSnapshot() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.triggerSnapshot();
                completed.complete(null);
            }
            catch (Exception e) {
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> pauseExporting() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                boolean pauseStatePersisted = this.adminControl.pauseExporting();
                if (this.adminControl.getExporterDirector() != null && pauseStatePersisted) {
                    this.adminControl.getExporterDirector().pauseExporting().onComplete((BiConsumer)completed);
                } else {
                    completed.complete(null);
                }
            }
            catch (IOException e) {
                LOG.error("Could not pause exporting", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> resumeExporting() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.resumeExporting();
                if (this.adminControl.getExporterDirector() != null && this.adminControl.shouldExport()) {
                    this.adminControl.getExporterDirector().resumeExporting().onComplete((BiConsumer)completed);
                } else {
                    completed.complete(null);
                }
            }
            catch (IOException e) {
                LOG.error("Could not resume exporting", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> pauseProcessing() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.pauseProcessing();
                if (this.adminControl.getStreamProcessor() != null && !this.adminControl.shouldProcess()) {
                    this.adminControl.getStreamProcessor().pauseProcessing().onComplete((BiConsumer)completed);
                } else {
                    completed.complete(null);
                }
            }
            catch (IOException e) {
                LOG.error("Could not pause processing state", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> resumeProcessing() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.resumeProcessing();
                if (this.adminControl.getStreamProcessor() != null && this.adminControl.shouldProcess()) {
                    this.adminControl.getStreamProcessor().resumeProcessing();
                }
                completed.complete(null);
            }
            catch (IOException e) {
                LOG.error("Could not resume processing", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }
}

