/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;

public final class SecurityCfg
implements ConfigurationEntry {
    private static final boolean DEFAULT_ENABLED = false;
    private boolean enabled = false;
    private File certificateChainPath;
    private File privateKeyPath;

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        Path brokerBasePath = Path.of(brokerBase, new String[0]);
        if (this.certificateChainPath != null) {
            this.certificateChainPath = brokerBasePath.resolve(this.certificateChainPath.toPath()).toFile();
        }
        if (this.privateKeyPath != null) {
            this.privateKeyPath = brokerBasePath.resolve(this.privateKeyPath.toPath()).toFile();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SecurityCfg setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public File getCertificateChainPath() {
        return this.certificateChainPath;
    }

    public SecurityCfg setCertificateChainPath(File certificateChainPath) {
        this.certificateChainPath = certificateChainPath;
        return this;
    }

    public File getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public SecurityCfg setPrivateKeyPath(File privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.certificateChainPath, this.privateKeyPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityCfg that = (SecurityCfg)o;
        return this.enabled == that.enabled && Objects.equals(this.certificateChainPath, that.certificateChainPath) && Objects.equals(this.privateKeyPath, that.privateKeyPath);
    }

    public String toString() {
        return "SecurityCfg{enabled=" + this.enabled + ", certificateChainPath='" + this.certificateChainPath + "', privateKeyPath='" + this.privateKeyPath + "'}";
    }
}

