/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.camunda.zeebe.broker.partitioning.PartitionAdminAccess;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.ActorFutureCollector;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

final class MultiPartitionAdminAccess
implements PartitionAdminAccess {
    private final ConcurrencyControl concurrencyControl;
    private final List<? extends PartitionAdminAccess> partitions;

    MultiPartitionAdminAccess(ConcurrencyControl concurrencyControl, List<? extends PartitionAdminAccess> partitions) {
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
        this.partitions = Collections.unmodifiableList(Objects.requireNonNull(partitions));
    }

    @Override
    public ActorFuture<Void> takeSnapshot() {
        return this.callOnEachPartition(PartitionAdminAccess::takeSnapshot);
    }

    @Override
    public ActorFuture<Void> pauseExporting() {
        return this.callOnEachPartition(PartitionAdminAccess::pauseExporting);
    }

    @Override
    public ActorFuture<Void> resumeExporting() {
        return this.callOnEachPartition(PartitionAdminAccess::resumeExporting);
    }

    @Override
    public ActorFuture<Void> pauseProcessing() {
        return this.callOnEachPartition(PartitionAdminAccess::pauseProcessing);
    }

    @Override
    public ActorFuture<Void> resumeProcessing() {
        return this.callOnEachPartition(PartitionAdminAccess::resumeProcessing);
    }

    private ActorFuture<Void> callOnEachPartition(Function<PartitionAdminAccess, ActorFuture<Void>> functionToCall) {
        ActorFuture response = this.concurrencyControl.createFuture();
        ActorFuture aggregatedResult = (ActorFuture)this.partitions.stream().map(functionToCall).collect(new ActorFutureCollector(this.concurrencyControl));
        this.concurrencyControl.runOnCompletion(aggregatedResult, (value, error) -> {
            if (error != null) {
                response.completeExceptionally(error);
            } else {
                response.complete(null);
            }
        });
        return response;
    }
}

