/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.MessagingConfig;
import io.atomix.cluster.messaging.impl.NettyMessagingService;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.SecurityCfg;
import io.camunda.zeebe.broker.system.configuration.SocketBindingCfg;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.List;
import org.slf4j.Logger;

public class ApiMessagingServiceStep
extends AbstractBrokerStartupStep {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        BrokerCfg brokerCfg = brokerStartupContext.getBrokerConfiguration();
        SocketBindingCfg.CommandApiCfg commandApiCfg = brokerCfg.getNetwork().getCommandApi();
        SecurityCfg securityCfg = brokerCfg.getNetwork().getSecurity();
        MessagingConfig messagingConfig = new MessagingConfig();
        messagingConfig.setInterfaces(List.of(commandApiCfg.getHost()));
        messagingConfig.setPort(Integer.valueOf(commandApiCfg.getPort()));
        if (securityCfg.isEnabled()) {
            messagingConfig.setTlsEnabled(true).setCertificateChain(securityCfg.getCertificateChainPath()).setPrivateKey(securityCfg.getPrivateKeyPath());
        }
        NettyMessagingService messagingService = new NettyMessagingService(brokerCfg.getCluster().getClusterName(), Address.from((String)commandApiCfg.getAdvertisedHost(), (int)commandApiCfg.getAdvertisedPort()), messagingConfig);
        messagingService.start().whenComplete((createdMessagingService, error) -> {
            if (error != null) {
                startupFuture.completeExceptionally(error);
            } else {
                concurrencyControl.run(() -> {
                    LOG.debug("Bound API to {}, using advertised address {} ", (Object)messagingService.bindingAddresses(), (Object)messagingService.address());
                    brokerStartupContext.setApiMessagingService((ManagedMessagingService)messagingService);
                    startupFuture.complete((Object)brokerStartupContext);
                });
            }
        });
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        ManagedMessagingService messagingService = brokerShutdownContext.getApiMessagingService();
        if (messagingService == null) {
            shutdownFuture.complete((Object)brokerShutdownContext);
            return;
        }
        messagingService.stop().whenComplete((of, error) -> {
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
            } else {
                concurrencyControl.run(() -> {
                    brokerShutdownContext.setApiMessagingService(null);
                    shutdownFuture.complete((Object)brokerShutdownContext);
                });
            }
        });
    }

    public String getName() {
        return "API Messaging Service";
    }
}

