/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition;

import com.esotericsoftware.kryo.serializers.FieldSerializer;
import io.atomix.utils.memory.MemorySize;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStoreFactory;

public class RaftStorageConfig {
    private static final String DATA_PREFIX = ".data";
    private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x2000000;
    private static final boolean DEFAULT_FLUSH_EXPLICITLY = true;
    private static final long DEFAULT_FREE_DISK_SPACE = 0x40000000L;
    private static final int DEFAULT_JOURNAL_INDEX_DENSITY = 100;
    private String directory;
    private long segmentSize = 0x2000000L;
    private boolean flushExplicitly = true;
    private long freeDiskSpace = 0x40000000L;
    private int journalIndexDensity = 100;
    @FieldSerializer.Optional(value="SnapshotStoreFactory")
    private ReceivableSnapshotStoreFactory persistedSnapshotStoreFactory;

    public String getDirectory(String groupName) {
        return this.directory != null ? this.directory : System.getProperty("atomix.data", DATA_PREFIX) + "/" + groupName;
    }

    public MemorySize getSegmentSize() {
        return MemorySize.from((long)this.segmentSize);
    }

    public RaftStorageConfig setSegmentSize(MemorySize segmentSize) {
        this.segmentSize = segmentSize.bytes();
        return this;
    }

    public boolean shouldFlushExplicitly() {
        return this.flushExplicitly;
    }

    public RaftStorageConfig setFlushExplicitly(boolean flushExplicitly) {
        this.flushExplicitly = flushExplicitly;
        return this;
    }

    public RaftStorageConfig setDirectory(String directory) {
        this.directory = directory;
        return this;
    }

    public ReceivableSnapshotStoreFactory getPersistedSnapshotStoreFactory() {
        return this.persistedSnapshotStoreFactory;
    }

    public RaftStorageConfig setPersistedSnapshotStoreFactory(ReceivableSnapshotStoreFactory persistedSnapshotStoreFactory) {
        this.persistedSnapshotStoreFactory = persistedSnapshotStoreFactory;
        return this;
    }

    public long getFreeDiskSpace() {
        return this.freeDiskSpace;
    }

    public RaftStorageConfig setFreeDiskSpace(long freeDiskSpace) {
        this.freeDiskSpace = freeDiskSpace;
        return this;
    }

    public int getJournalIndexDensity() {
        return this.journalIndexDensity;
    }

    public RaftStorageConfig setJournalIndexDensity(int journalIndexDensity) {
        this.journalIndexDensity = journalIndexDensity;
        return this;
    }
}

