/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.intent;

import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;

public enum MessageSubscriptionIntent implements ProcessInstanceRelatedIntent
{
    CREATE(0),
    CREATED(1),
    CORRELATING(8),
    CORRELATE(2),
    CORRELATED(3),
    REJECT(4),
    REJECTED(5),
    DELETE(6),
    DELETED(7);

    private final short value;
    private final boolean shouldBlacklist;

    private MessageSubscriptionIntent(short value) {
        this(value, true);
    }

    private MessageSubscriptionIntent(short value, boolean shouldBlacklist) {
        this.value = value;
        this.shouldBlacklist = shouldBlacklist;
    }

    @Override
    public short value() {
        return this.value;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return CREATE;
            }
            case 1: {
                return CREATED;
            }
            case 2: {
                return CORRELATE;
            }
            case 3: {
                return CORRELATED;
            }
            case 4: {
                return REJECT;
            }
            case 5: {
                return REJECTED;
            }
            case 6: {
                return DELETE;
            }
            case 7: {
                return DELETED;
            }
            case 8: {
                return CORRELATING;
            }
        }
        return Intent.UNKNOWN;
    }

    @Override
    public boolean shouldBlacklistInstanceOnError() {
        return this.shouldBlacklist;
    }
}

