/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.intent;

import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;

public enum IncidentIntent implements ProcessInstanceRelatedIntent
{
    CREATED(0),
    RESOLVE(1, false),
    RESOLVED(2);

    private final short value;
    private final boolean shouldBlacklist;

    private IncidentIntent(short value) {
        this(value, true);
    }

    private IncidentIntent(short value, boolean shouldBlacklist) {
        this.value = value;
        this.shouldBlacklist = shouldBlacklist;
    }

    public short getIntent() {
        return this.value;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return CREATED;
            }
            case 1: {
                return RESOLVE;
            }
            case 2: {
                return RESOLVED;
            }
        }
        return Intent.UNKNOWN;
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean shouldBlacklistInstanceOnError() {
        return this.shouldBlacklist;
    }
}

