/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.management;

import io.camunda.zeebe.shared.management.ActorClockService;
import io.camunda.zeebe.util.sched.clock.ControlledActorClock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;

public final class ControlledActorClockService
implements ActorClockService,
ActorClockService.MutableClock {
    private final ControlledActorClock clock;

    public ControlledActorClockService(ControlledActorClock clock) {
        this.clock = clock;
    }

    @Override
    public long epochMilli() {
        return this.clock.getTimeMillis();
    }

    @Override
    public Optional<ActorClockService.MutableClock> mutable() {
        return Optional.of(this);
    }

    @Override
    public void addTime(Duration offset) {
        this.clock.addTime(offset);
    }

    @Override
    public void pinTime(Instant time) {
        this.clock.setCurrentTime(time);
    }

    @Override
    public void resetTime() {
        this.clock.reset();
    }
}

