/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.camunda.zeebe.broker.Broker;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.system.SystemContext;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.shared.ActorClockConfiguration;
import io.camunda.zeebe.shared.Profile;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;

@SpringBootApplication(scanBasePackages={"io.camunda.zeebe.broker", "io.camunda.zeebe.shared"})
@ConfigurationPropertiesScan(basePackages={"io.camunda.zeebe.broker", "io.camunda.zeebe.shared"})
public class StandaloneBroker
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent> {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final BrokerCfg configuration;
    private final Environment springEnvironment;
    private final SpringBrokerBridge springBrokerBridge;
    private final ActorClockConfiguration clockConfig;
    private String tempFolder;
    private SystemContext systemContext;
    private Broker broker;

    @Autowired
    public StandaloneBroker(BrokerCfg configuration, Environment springEnvironment, SpringBrokerBridge springBrokerBridge, ActorClockConfiguration clockConfig) {
        this.configuration = configuration;
        this.springEnvironment = springEnvironment;
        this.springBrokerBridge = springBrokerBridge;
        this.clockConfig = clockConfig;
    }

    public static void main(String[] args) {
        System.setProperty("spring.banner.location", "classpath:/assets/zeebe_broker_banner.txt");
        SpringApplication application = new SpringApplicationBuilder(new Class[]{StandaloneBroker.class}).web(WebApplicationType.SERVLET).logStartupInfo(true).profiles(new String[]{Profile.BROKER.getId()}).build(args);
        application.run(new String[0]);
    }

    public void run(String ... args) {
        if (this.shouldUseTemporaryFolder()) {
            LOG.info("Launching broker in temporary folder.");
            this.systemContext = this.createSystemContextInTempDirectory();
        } else {
            this.systemContext = this.createSystemContextInBaseDirectory();
        }
        this.systemContext.getScheduler().start();
        this.broker = new Broker(this.systemContext, this.springBrokerBridge);
        this.broker.start();
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        try {
            this.broker.close();
            this.systemContext.getScheduler().stop().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Shutdown interrupted, most likely harmless", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error("Failed to shutdown broker gracefully", (Throwable)e);
        }
        finally {
            this.deleteTempDirectory();
            LogManager.shutdown();
        }
    }

    private boolean shouldUseTemporaryFolder() {
        return this.springEnvironment.acceptsProfiles(Profiles.of((String[])new String[]{Profile.DEVELOPMENT.getId(), Profile.TEST.getId()}));
    }

    private SystemContext createSystemContextInBaseDirectory() {
        String basePath = System.getProperty("basedir");
        if (basePath == null) {
            basePath = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        }
        return new SystemContext(this.configuration, basePath, this.clockConfig.getClock());
    }

    private SystemContext createSystemContextInTempDirectory() {
        try {
            this.tempFolder = Files.createTempDirectory("zeebe", new FileAttribute[0]).toAbsolutePath().normalize().toString();
            return new SystemContext(this.configuration, this.tempFolder, this.clockConfig.getClock());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not create system context", e);
        }
    }

    private void deleteTempDirectory() {
        if (this.tempFolder != null) {
            try {
                FileUtil.deleteFolder((String)this.tempFolder);
            }
            catch (IOException e) {
                LOG.error("Failed to delete temporary folder {}", (Object)this.tempFolder, (Object)e);
            }
        }
    }
}

