/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public class ElasticsearchMetrics {
    private static final String NAMESPACE = "zeebe_elasticsearch_exporter";
    private static final String PARTITION_LABEL = "partition";
    private static final Histogram FLUSH_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe_elasticsearch_exporter")).name("flush_duration_seconds")).help("Flush duration of bulk exporters in seconds")).labelNames(new String[]{"partition"})).register();
    private static final Counter FAILED_FLUSH = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe_elasticsearch_exporter")).name("failed_flush")).help("Number of failed flush operations")).labelNames(new String[]{"partition"})).register();
    private static final Histogram BULK_SIZE = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe_elasticsearch_exporter")).name("bulk_size")).help("Exporter bulk size")).buckets(new double[]{10.0, 100.0, 1000.0, 10000.0, 100000.0}).labelNames(new String[]{"partition"})).register();
    private static final Gauge BULK_MEMORY_SIZE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe_elasticsearch_exporter")).name("bulk_memory_size")).help("Exporter bulk memory size")).labelNames(new String[]{"partition"})).register();
    private final String partitionIdLabel;

    public ElasticsearchMetrics(int partitionId) {
        this.partitionIdLabel = String.valueOf(partitionId);
    }

    public Histogram.Timer measureFlushDuration() {
        return ((Histogram.Child)FLUSH_DURATION.labels(new String[]{this.partitionIdLabel})).startTimer();
    }

    public void recordBulkSize(int bulkSize) {
        ((Histogram.Child)BULK_SIZE.labels(new String[]{this.partitionIdLabel})).observe((double)bulkSize);
    }

    public void recordBulkMemorySize(int bulkMemorySize) {
        ((Gauge.Child)BULK_MEMORY_SIZE.labels(new String[]{this.partitionIdLabel})).set((double)bulkMemorySize);
    }

    public void recordFailedFlush() {
        ((Counter.Child)FAILED_FLUSH.labels(new String[]{this.partitionIdLabel})).inc();
    }
}

