/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.SnapshotChunk;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;

final class SnapshotChunkUtil {
    private SnapshotChunkUtil() {
    }

    static long createChecksum(byte[] content) {
        Checksum checksum = SnapshotChunkUtil.newChecksum();
        checksum.update(content);
        return checksum.getValue();
    }

    static Checksum newChecksum() {
        return new CRC32C();
    }

    static SnapshotChunk createSnapshotChunkFromFile(Path chunkFile, String snapshotId, int totalCount, long snapshotChecksum) throws IOException {
        byte[] content = Files.readAllBytes(chunkFile);
        long checksum = SnapshotChunkUtil.createChecksum(content);
        return new SnapshotChunkImpl(snapshotId, totalCount, chunkFile.getFileName().toString(), checksum, content, snapshotChecksum);
    }

    private static final class SnapshotChunkImpl
    implements SnapshotChunk {
        private final String snapshotId;
        private final int totalCount;
        private final String chunkName;
        private final byte[] content;
        private final long snapshotChecksum;
        private final long checksum;

        SnapshotChunkImpl(String snapshotId, int totalCount, String chunkName, long checksum, byte[] content, long snapshotChecksum) {
            this.snapshotId = snapshotId;
            this.totalCount = totalCount;
            this.chunkName = chunkName;
            this.checksum = checksum;
            this.content = content;
            this.snapshotChecksum = snapshotChecksum;
        }

        @Override
        public String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public int getTotalCount() {
            return this.totalCount;
        }

        @Override
        public String getChunkName() {
            return this.chunkName;
        }

        @Override
        public long getChecksum() {
            return this.checksum;
        }

        @Override
        public byte[] getContent() {
            return this.content;
        }

        @Override
        public long getSnapshotChecksum() {
            return this.snapshotChecksum;
        }
    }
}

