/*
 * Orchestration Cluster REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.UsageMetricsResponseItem;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * UsageMetricsResponse
 */
@JsonPropertyOrder({
  UsageMetricsResponse.JSON_PROPERTY_ACTIVE_TENANTS,
  UsageMetricsResponse.JSON_PROPERTY_TENANTS,
  UsageMetricsResponse.JSON_PROPERTY_PROCESS_INSTANCES,
  UsageMetricsResponse.JSON_PROPERTY_DECISION_INSTANCES,
  UsageMetricsResponse.JSON_PROPERTY_ASSIGNEES
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-08-01T15:33:30.654188406Z[GMT]", comments = "Generator version: 7.12.0")
public class UsageMetricsResponse {
  public static final String JSON_PROPERTY_ACTIVE_TENANTS = "activeTenants";
  @javax.annotation.Nullable
  private Long activeTenants;

  public static final String JSON_PROPERTY_TENANTS = "tenants";
  @javax.annotation.Nullable
  private Map<String, UsageMetricsResponseItem> tenants = new HashMap<>();

  public static final String JSON_PROPERTY_PROCESS_INSTANCES = "processInstances";
  @javax.annotation.Nullable
  private Long processInstances;

  public static final String JSON_PROPERTY_DECISION_INSTANCES = "decisionInstances";
  @javax.annotation.Nullable
  private Long decisionInstances;

  public static final String JSON_PROPERTY_ASSIGNEES = "assignees";
  @javax.annotation.Nullable
  private Long assignees;

  public UsageMetricsResponse() {
  }

  public UsageMetricsResponse activeTenants(@javax.annotation.Nullable Long activeTenants) {
    
    this.activeTenants = activeTenants;
    return this;
  }

  /**
   * The amount of active tenants.
   * @return activeTenants
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACTIVE_TENANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getActiveTenants() {
    return activeTenants;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_TENANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActiveTenants(@javax.annotation.Nullable Long activeTenants) {
    this.activeTenants = activeTenants;
  }

  public UsageMetricsResponse tenants(@javax.annotation.Nullable Map<String, UsageMetricsResponseItem> tenants) {
    
    this.tenants = tenants;
    return this;
  }

  public UsageMetricsResponse putTenantsItem(String key, UsageMetricsResponseItem tenantsItem) {
    if (this.tenants == null) {
      this.tenants = new HashMap<>();
    }
    this.tenants.put(key, tenantsItem);
    return this;
  }

  /**
   * The usage metrics by tenants. Only available if request &#x60;withTenants&#x60; query parameter was &#x60;true&#x60;.
   * @return tenants
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, UsageMetricsResponseItem> getTenants() {
    return tenants;
  }


  @JsonProperty(JSON_PROPERTY_TENANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenants(@javax.annotation.Nullable Map<String, UsageMetricsResponseItem> tenants) {
    this.tenants = tenants;
  }

  public UsageMetricsResponse processInstances(@javax.annotation.Nullable Long processInstances) {
    
    this.processInstances = processInstances;
    return this;
  }

  /**
   * The amount of created root process instances.
   * @return processInstances
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getProcessInstances() {
    return processInstances;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstances(@javax.annotation.Nullable Long processInstances) {
    this.processInstances = processInstances;
  }

  public UsageMetricsResponse decisionInstances(@javax.annotation.Nullable Long decisionInstances) {
    
    this.decisionInstances = decisionInstances;
    return this;
  }

  /**
   * The amount of executed decision instances.
   * @return decisionInstances
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDecisionInstances() {
    return decisionInstances;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionInstances(@javax.annotation.Nullable Long decisionInstances) {
    this.decisionInstances = decisionInstances;
  }

  public UsageMetricsResponse assignees(@javax.annotation.Nullable Long assignees) {
    
    this.assignees = assignees;
    return this;
  }

  /**
   * The amount of unique active task users.
   * @return assignees
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ASSIGNEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAssignees() {
    return assignees;
  }


  @JsonProperty(JSON_PROPERTY_ASSIGNEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssignees(@javax.annotation.Nullable Long assignees) {
    this.assignees = assignees;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UsageMetricsResponse usageMetricsResponse = (UsageMetricsResponse) o;
    return Objects.equals(this.activeTenants, usageMetricsResponse.activeTenants) &&
        Objects.equals(this.tenants, usageMetricsResponse.tenants) &&
        Objects.equals(this.processInstances, usageMetricsResponse.processInstances) &&
        Objects.equals(this.decisionInstances, usageMetricsResponse.decisionInstances) &&
        Objects.equals(this.assignees, usageMetricsResponse.assignees);
  }

  @Override
  public int hashCode() {
    return Objects.hash(activeTenants, tenants, processInstances, decisionInstances, assignees);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UsageMetricsResponse {\n");
    sb.append("    activeTenants: ").append(toIndentedString(activeTenants)).append("\n");
    sb.append("    tenants: ").append(toIndentedString(tenants)).append("\n");
    sb.append("    processInstances: ").append(toIndentedString(processInstances)).append("\n");
    sb.append("    decisionInstances: ").append(toIndentedString(decisionInstances)).append("\n");
    sb.append("    assignees: ").append(toIndentedString(assignees)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processInstances` to the URL query string
    if (getProcessInstances() != null) {
      try {
        joiner.add(String.format("%sprocessInstances%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstances()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionInstances` to the URL query string
    if (getDecisionInstances() != null) {
      try {
        joiner.add(String.format("%sdecisionInstances%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionInstances()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assignees` to the URL query string
    if (getAssignees() != null) {
      try {
        joiner.add(String.format("%sassignees%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssignees()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

