/*
 * Orchestration Cluster REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.ModifyProcessInstanceVariableInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Instructions describing an element that should be activated.
 */
@JsonPropertyOrder({
  ProcessInstanceModificationActivateInstruction.JSON_PROPERTY_ELEMENT_ID,
  ProcessInstanceModificationActivateInstruction.JSON_PROPERTY_VARIABLE_INSTRUCTIONS,
  ProcessInstanceModificationActivateInstruction.JSON_PROPERTY_ANCESTOR_ELEMENT_INSTANCE_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-08-01T15:33:30.654188406Z[GMT]", comments = "Generator version: 7.12.0")
public class ProcessInstanceModificationActivateInstruction {
  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  @javax.annotation.Nonnull
  private String elementId;

  public static final String JSON_PROPERTY_VARIABLE_INSTRUCTIONS = "variableInstructions";
  @javax.annotation.Nullable
  private List<ModifyProcessInstanceVariableInstruction> variableInstructions = new ArrayList<>();

  public static final String JSON_PROPERTY_ANCESTOR_ELEMENT_INSTANCE_KEY = "ancestorElementInstanceKey";
  @javax.annotation.Nullable
  private String ancestorElementInstanceKey = "-1";

  public ProcessInstanceModificationActivateInstruction() {
  }

  public ProcessInstanceModificationActivateInstruction elementId(@javax.annotation.Nonnull String elementId) {
    
    this.elementId = elementId;
    return this;
  }

  /**
   * The ID of the element that should be activated.
   * @return elementId
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getElementId() {
    return elementId;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setElementId(@javax.annotation.Nonnull String elementId) {
    this.elementId = elementId;
  }

  public ProcessInstanceModificationActivateInstruction variableInstructions(@javax.annotation.Nullable List<ModifyProcessInstanceVariableInstruction> variableInstructions) {
    
    this.variableInstructions = variableInstructions;
    return this;
  }

  public ProcessInstanceModificationActivateInstruction addVariableInstructionsItem(ModifyProcessInstanceVariableInstruction variableInstructionsItem) {
    if (this.variableInstructions == null) {
      this.variableInstructions = new ArrayList<>();
    }
    this.variableInstructions.add(variableInstructionsItem);
    return this;
  }

  /**
   * Instructions describing which variables should be created.
   * @return variableInstructions
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VARIABLE_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ModifyProcessInstanceVariableInstruction> getVariableInstructions() {
    return variableInstructions;
  }


  @JsonProperty(JSON_PROPERTY_VARIABLE_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariableInstructions(@javax.annotation.Nullable List<ModifyProcessInstanceVariableInstruction> variableInstructions) {
    this.variableInstructions = variableInstructions;
  }

  public ProcessInstanceModificationActivateInstruction ancestorElementInstanceKey(@javax.annotation.Nullable String ancestorElementInstanceKey) {
    
    this.ancestorElementInstanceKey = ancestorElementInstanceKey;
    return this;
  }

  /**
   * The key of the ancestor scope the element instance should be created in. Set to -1 to create the new element instance within an existing element instance of the flow scope. 
   * @return ancestorElementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ANCESTOR_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAncestorElementInstanceKey() {
    return ancestorElementInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_ANCESTOR_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAncestorElementInstanceKey(@javax.annotation.Nullable String ancestorElementInstanceKey) {
    this.ancestorElementInstanceKey = ancestorElementInstanceKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceModificationActivateInstruction processInstanceModificationActivateInstruction = (ProcessInstanceModificationActivateInstruction) o;
    return Objects.equals(this.elementId, processInstanceModificationActivateInstruction.elementId) &&
        Objects.equals(this.variableInstructions, processInstanceModificationActivateInstruction.variableInstructions) &&
        Objects.equals(this.ancestorElementInstanceKey, processInstanceModificationActivateInstruction.ancestorElementInstanceKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(elementId, variableInstructions, ancestorElementInstanceKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceModificationActivateInstruction {\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    variableInstructions: ").append(toIndentedString(variableInstructions)).append("\n");
    sb.append("    ancestorElementInstanceKey: ").append(toIndentedString(ancestorElementInstanceKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `elementId` to the URL query string
    if (getElementId() != null) {
      try {
        joiner.add(String.format("%selementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getElementId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableInstructions` to the URL query string
    if (getVariableInstructions() != null) {
      for (int i = 0; i < getVariableInstructions().size(); i++) {
        if (getVariableInstructions().get(i) != null) {
          joiner.add(getVariableInstructions().get(i).toUrlQueryString(String.format("%svariableInstructions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `ancestorElementInstanceKey` to the URL query string
    if (getAncestorElementInstanceKey() != null) {
      try {
        joiner.add(String.format("%sancestorElementInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAncestorElementInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

