/*
 * Orchestration Cluster REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.ElementInstanceStateEnum;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ElementInstanceResult
 */
@JsonPropertyOrder({
  ElementInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ElementInstanceResult.JSON_PROPERTY_START_DATE,
  ElementInstanceResult.JSON_PROPERTY_END_DATE,
  ElementInstanceResult.JSON_PROPERTY_ELEMENT_ID,
  ElementInstanceResult.JSON_PROPERTY_ELEMENT_NAME,
  ElementInstanceResult.JSON_PROPERTY_TYPE,
  ElementInstanceResult.JSON_PROPERTY_STATE,
  ElementInstanceResult.JSON_PROPERTY_HAS_INCIDENT,
  ElementInstanceResult.JSON_PROPERTY_TENANT_ID,
  ElementInstanceResult.JSON_PROPERTY_ELEMENT_INSTANCE_KEY,
  ElementInstanceResult.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  ElementInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  ElementInstanceResult.JSON_PROPERTY_INCIDENT_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-08-01T15:33:30.654188406Z[GMT]", comments = "Generator version: 7.12.0")
public class ElementInstanceResult {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable
  private String processDefinitionId;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @javax.annotation.Nullable
  private String startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @javax.annotation.Nullable
  private String endDate;

  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  @javax.annotation.Nullable
  private String elementId;

  public static final String JSON_PROPERTY_ELEMENT_NAME = "elementName";
  @javax.annotation.Nullable
  private String elementName;

  /**
   * Type of element as defined set of values.
   */
  public enum TypeEnum {
    UNSPECIFIED(String.valueOf("UNSPECIFIED")),
    
    PROCESS(String.valueOf("PROCESS")),
    
    SUB_PROCESS(String.valueOf("SUB_PROCESS")),
    
    EVENT_SUB_PROCESS(String.valueOf("EVENT_SUB_PROCESS")),
    
    AD_HOC_SUB_PROCESS(String.valueOf("AD_HOC_SUB_PROCESS")),
    
    START_EVENT(String.valueOf("START_EVENT")),
    
    INTERMEDIATE_CATCH_EVENT(String.valueOf("INTERMEDIATE_CATCH_EVENT")),
    
    INTERMEDIATE_THROW_EVENT(String.valueOf("INTERMEDIATE_THROW_EVENT")),
    
    BOUNDARY_EVENT(String.valueOf("BOUNDARY_EVENT")),
    
    END_EVENT(String.valueOf("END_EVENT")),
    
    SERVICE_TASK(String.valueOf("SERVICE_TASK")),
    
    RECEIVE_TASK(String.valueOf("RECEIVE_TASK")),
    
    USER_TASK(String.valueOf("USER_TASK")),
    
    MANUAL_TASK(String.valueOf("MANUAL_TASK")),
    
    TASK(String.valueOf("TASK")),
    
    EXCLUSIVE_GATEWAY(String.valueOf("EXCLUSIVE_GATEWAY")),
    
    INCLUSIVE_GATEWAY(String.valueOf("INCLUSIVE_GATEWAY")),
    
    PARALLEL_GATEWAY(String.valueOf("PARALLEL_GATEWAY")),
    
    EVENT_BASED_GATEWAY(String.valueOf("EVENT_BASED_GATEWAY")),
    
    SEQUENCE_FLOW(String.valueOf("SEQUENCE_FLOW")),
    
    MULTI_INSTANCE_BODY(String.valueOf("MULTI_INSTANCE_BODY")),
    
    CALL_ACTIVITY(String.valueOf("CALL_ACTIVITY")),
    
    BUSINESS_RULE_TASK(String.valueOf("BUSINESS_RULE_TASK")),
    
    SCRIPT_TASK(String.valueOf("SCRIPT_TASK")),
    
    SEND_TASK(String.valueOf("SEND_TASK")),
    
    UNKNOWN(String.valueOf("UNKNOWN")),
    
    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @javax.annotation.Nullable
  private TypeEnum type;

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable
  private ElementInstanceStateEnum state;

  public static final String JSON_PROPERTY_HAS_INCIDENT = "hasIncident";
  @javax.annotation.Nullable
  private Boolean hasIncident;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public static final String JSON_PROPERTY_ELEMENT_INSTANCE_KEY = "elementInstanceKey";
  @javax.annotation.Nullable
  private String elementInstanceKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable
  private String processInstanceKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable
  private String processDefinitionKey;

  public static final String JSON_PROPERTY_INCIDENT_KEY = "incidentKey";
  @javax.annotation.Nullable
  private String incidentKey;

  public ElementInstanceResult() {
  }

  public ElementInstanceResult processDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The process definition ID associated to this element instance.
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ElementInstanceResult startDate(@javax.annotation.Nullable String startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Date when element instance started.
   * @return startDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(@javax.annotation.Nullable String startDate) {
    this.startDate = startDate;
  }

  public ElementInstanceResult endDate(@javax.annotation.Nullable String endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * Date when element instance finished.
   * @return endDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(@javax.annotation.Nullable String endDate) {
    this.endDate = endDate;
  }

  public ElementInstanceResult elementId(@javax.annotation.Nullable String elementId) {
    
    this.elementId = elementId;
    return this;
  }

  /**
   * The element ID for this element instance.
   * @return elementId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getElementId() {
    return elementId;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementId(@javax.annotation.Nullable String elementId) {
    this.elementId = elementId;
  }

  public ElementInstanceResult elementName(@javax.annotation.Nullable String elementName) {
    
    this.elementName = elementName;
    return this;
  }

  /**
   * The element name for this element instance.
   * @return elementName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getElementName() {
    return elementName;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementName(@javax.annotation.Nullable String elementName) {
    this.elementName = elementName;
  }

  public ElementInstanceResult type(@javax.annotation.Nullable TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Type of element as defined set of values.
   * @return type
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@javax.annotation.Nullable TypeEnum type) {
    this.type = type;
  }

  public ElementInstanceResult state(@javax.annotation.Nullable ElementInstanceStateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * State of element instance as defined set of values.
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ElementInstanceStateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable ElementInstanceStateEnum state) {
    this.state = state;
  }

  public ElementInstanceResult hasIncident(@javax.annotation.Nullable Boolean hasIncident) {
    
    this.hasIncident = hasIncident;
    return this;
  }

  /**
   * Shows whether this element instance has an incident. If true also an incidentKey is provided.
   * @return hasIncident
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HAS_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasIncident() {
    return hasIncident;
  }


  @JsonProperty(JSON_PROPERTY_HAS_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasIncident(@javax.annotation.Nullable Boolean hasIncident) {
    this.hasIncident = hasIncident;
  }

  public ElementInstanceResult tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the incident.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public ElementInstanceResult elementInstanceKey(@javax.annotation.Nullable String elementInstanceKey) {
    
    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this element instance.
   * @return elementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getElementInstanceKey() {
    return elementInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementInstanceKey(@javax.annotation.Nullable String elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public ElementInstanceResult processInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key associated to this element instance.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public ElementInstanceResult processDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key associated to this element instance.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public ElementInstanceResult incidentKey(@javax.annotation.Nullable String incidentKey) {
    
    this.incidentKey = incidentKey;
    return this;
  }

  /**
   * Incident key associated with this element instance.
   * @return incidentKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INCIDENT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIncidentKey() {
    return incidentKey;
  }


  @JsonProperty(JSON_PROPERTY_INCIDENT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncidentKey(@javax.annotation.Nullable String incidentKey) {
    this.incidentKey = incidentKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ElementInstanceResult elementInstanceResult = (ElementInstanceResult) o;
    return Objects.equals(this.processDefinitionId, elementInstanceResult.processDefinitionId) &&
        Objects.equals(this.startDate, elementInstanceResult.startDate) &&
        Objects.equals(this.endDate, elementInstanceResult.endDate) &&
        Objects.equals(this.elementId, elementInstanceResult.elementId) &&
        Objects.equals(this.elementName, elementInstanceResult.elementName) &&
        Objects.equals(this.type, elementInstanceResult.type) &&
        Objects.equals(this.state, elementInstanceResult.state) &&
        Objects.equals(this.hasIncident, elementInstanceResult.hasIncident) &&
        Objects.equals(this.tenantId, elementInstanceResult.tenantId) &&
        Objects.equals(this.elementInstanceKey, elementInstanceResult.elementInstanceKey) &&
        Objects.equals(this.processInstanceKey, elementInstanceResult.processInstanceKey) &&
        Objects.equals(this.processDefinitionKey, elementInstanceResult.processDefinitionKey) &&
        Objects.equals(this.incidentKey, elementInstanceResult.incidentKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionId, startDate, endDate, elementId, elementName, type, state, hasIncident, tenantId, elementInstanceKey, processInstanceKey, processDefinitionKey, incidentKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ElementInstanceResult {\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    elementName: ").append(toIndentedString(elementName)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    hasIncident: ").append(toIndentedString(hasIncident)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    incidentKey: ").append(toIndentedString(incidentKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startDate` to the URL query string
    if (getStartDate() != null) {
      try {
        joiner.add(String.format("%sstartDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `endDate` to the URL query string
    if (getEndDate() != null) {
      try {
        joiner.add(String.format("%sendDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEndDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `elementId` to the URL query string
    if (getElementId() != null) {
      try {
        joiner.add(String.format("%selementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getElementId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `elementName` to the URL query string
    if (getElementName() != null) {
      try {
        joiner.add(String.format("%selementName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getElementName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `hasIncident` to the URL query string
    if (getHasIncident() != null) {
      try {
        joiner.add(String.format("%shasIncident%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHasIncident()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `elementInstanceKey` to the URL query string
    if (getElementInstanceKey() != null) {
      try {
        joiner.add(String.format("%selementInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getElementInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentKey` to the URL query string
    if (getIncidentKey() != null) {
      try {
        joiner.add(String.format("%sincidentKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

