/*
 * Orchestration Cluster REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * BatchOperationItemResponse
 */
@JsonPropertyOrder({
  BatchOperationItemResponse.JSON_PROPERTY_BATCH_OPERATION_KEY,
  BatchOperationItemResponse.JSON_PROPERTY_ITEM_KEY,
  BatchOperationItemResponse.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  BatchOperationItemResponse.JSON_PROPERTY_STATE,
  BatchOperationItemResponse.JSON_PROPERTY_PROCESSED_DATE,
  BatchOperationItemResponse.JSON_PROPERTY_ERROR_MESSAGE
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-08-01T15:33:30.654188406Z[GMT]", comments = "Generator version: 7.12.0")
public class BatchOperationItemResponse {
  public static final String JSON_PROPERTY_BATCH_OPERATION_KEY = "batchOperationKey";
  @javax.annotation.Nullable
  private String batchOperationKey;

  public static final String JSON_PROPERTY_ITEM_KEY = "itemKey";
  @javax.annotation.Nullable
  private String itemKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable
  private String processInstanceKey;

  /**
   * State of the item.
   */
  public enum StateEnum {
    ACTIVE(String.valueOf("ACTIVE")),
    
    COMPLETED(String.valueOf("COMPLETED")),
    
    CANCELED(String.valueOf("CANCELED")),
    
    FAILED(String.valueOf("FAILED")),
    
    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable
  private StateEnum state;

  public static final String JSON_PROPERTY_PROCESSED_DATE = "processedDate";
  @javax.annotation.Nullable
  private String processedDate;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  @javax.annotation.Nullable
  private String errorMessage;

  public BatchOperationItemResponse() {
  }

  public BatchOperationItemResponse batchOperationKey(@javax.annotation.Nullable String batchOperationKey) {
    
    this.batchOperationKey = batchOperationKey;
    return this;
  }

  /**
   * The key (or operate legacy ID) of the batch operation.
   * @return batchOperationKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BATCH_OPERATION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBatchOperationKey() {
    return batchOperationKey;
  }


  @JsonProperty(JSON_PROPERTY_BATCH_OPERATION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBatchOperationKey(@javax.annotation.Nullable String batchOperationKey) {
    this.batchOperationKey = batchOperationKey;
  }

  public BatchOperationItemResponse itemKey(@javax.annotation.Nullable String itemKey) {
    
    this.itemKey = itemKey;
    return this;
  }

  /**
   * Key of the item, e.g. a process instance key.
   * @return itemKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ITEM_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getItemKey() {
    return itemKey;
  }


  @JsonProperty(JSON_PROPERTY_ITEM_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItemKey(@javax.annotation.Nullable String itemKey) {
    this.itemKey = itemKey;
  }

  public BatchOperationItemResponse processInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * the process instance key of the processed item.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public BatchOperationItemResponse state(@javax.annotation.Nullable StateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * State of the item.
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable StateEnum state) {
    this.state = state;
  }

  public BatchOperationItemResponse processedDate(@javax.annotation.Nullable String processedDate) {
    
    this.processedDate = processedDate;
    return this;
  }

  /**
   * the date this item was processed.
   * @return processedDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESSED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessedDate() {
    return processedDate;
  }


  @JsonProperty(JSON_PROPERTY_PROCESSED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessedDate(@javax.annotation.Nullable String processedDate) {
    this.processedDate = processedDate;
  }

  public BatchOperationItemResponse errorMessage(@javax.annotation.Nullable String errorMessage) {
    
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * the error message from the engine in case of a failed operation.
   * @return errorMessage
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getErrorMessage() {
    return errorMessage;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessage(@javax.annotation.Nullable String errorMessage) {
    this.errorMessage = errorMessage;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BatchOperationItemResponse batchOperationItemResponse = (BatchOperationItemResponse) o;
    return Objects.equals(this.batchOperationKey, batchOperationItemResponse.batchOperationKey) &&
        Objects.equals(this.itemKey, batchOperationItemResponse.itemKey) &&
        Objects.equals(this.processInstanceKey, batchOperationItemResponse.processInstanceKey) &&
        Objects.equals(this.state, batchOperationItemResponse.state) &&
        Objects.equals(this.processedDate, batchOperationItemResponse.processedDate) &&
        Objects.equals(this.errorMessage, batchOperationItemResponse.errorMessage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(batchOperationKey, itemKey, processInstanceKey, state, processedDate, errorMessage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BatchOperationItemResponse {\n");
    sb.append("    batchOperationKey: ").append(toIndentedString(batchOperationKey)).append("\n");
    sb.append("    itemKey: ").append(toIndentedString(itemKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    processedDate: ").append(toIndentedString(processedDate)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `batchOperationKey` to the URL query string
    if (getBatchOperationKey() != null) {
      try {
        joiner.add(String.format("%sbatchOperationKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBatchOperationKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `itemKey` to the URL query string
    if (getItemKey() != null) {
      try {
        joiner.add(String.format("%sitemKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getItemKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processedDate` to the URL query string
    if (getProcessedDate() != null) {
      try {
        joiner.add(String.format("%sprocessedDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessedDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorMessage` to the URL query string
    if (getErrorMessage() != null) {
      try {
        joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

