/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.impl.http.ApiEntity;
import io.camunda.zeebe.client.impl.http.CircularBufferInputStream;
import io.camunda.zeebe.client.impl.http.TypedApiEntityConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;

public class DocumentDataConsumer<T>
implements AsyncEntityConsumer<ApiEntity<T>>,
CircularBufferInputStream.CapacityCallback {
    private final CircularBufferInputStream inputStream;
    private FutureCallback<ApiEntity<T>> resultCallback;
    private final int maxCapacity;
    private volatile CapacityChannel capacityChannel;
    private volatile boolean completed = false;
    private volatile boolean problemDetail = false;
    private final TypedApiEntityConsumer.JsonApiEntityConsumer<InputStream> problemDetailConsumer;

    public DocumentDataConsumer(int bufferCapacity, ObjectMapper json) {
        this.maxCapacity = bufferCapacity;
        this.inputStream = new CircularBufferInputStream(bufferCapacity);
        try {
            this.problemDetailConsumer = new TypedApiEntityConsumer.JsonApiEntityConsumer<InputStream>(json, InputStream.class, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void streamStart(EntityDetails entityDetails, FutureCallback<ApiEntity<T>> resultCallback) {
        ContentType contentType;
        this.resultCallback = resultCallback;
        ContentType contentType2 = contentType = entityDetails != null ? ContentType.parse((CharSequence)entityDetails.getContentType()) : null;
        if (ContentType.APPLICATION_PROBLEM_JSON.isSameMimeType(contentType)) {
            this.problemDetail = true;
        } else {
            this.problemDetail = false;
            this.inputStream.setCapacityCallback(this);
            resultCallback.completed(ApiEntity.of(this.inputStream));
        }
    }

    public void failed(Exception cause) {
        if (cause instanceof IOException) {
            this.inputStream.signalError((IOException)cause);
        } else {
            this.inputStream.signalError(new IOException(cause));
        }
        if (this.resultCallback != null && !this.completed) {
            this.resultCallback.failed(cause);
        }
    }

    public ApiEntity<T> getContent() {
        if (this.problemDetail) {
            try {
                return this.problemDetailConsumer.generateContent();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ApiEntity.of(this.inputStream);
    }

    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        if (this.problemDetail) {
            capacityChannel.update(this.maxCapacity - this.problemDetailConsumer.getBufferedBytes());
            return;
        }
        this.capacityChannel = capacityChannel;
        int availableSpace = this.inputStream.getAvailableSpace();
        if (availableSpace > 0) {
            capacityChannel.update(availableSpace);
        }
    }

    public void consume(ByteBuffer src) throws IOException {
        if (this.problemDetail) {
            this.problemDetailConsumer.consumeData(src, false);
        }
        this.inputStream.write(src);
    }

    public void streamEnd(List<? extends Header> trailers) throws IOException {
        if (this.problemDetail) {
            this.problemDetailConsumer.consumeData(ByteBuffer.allocate(0), true);
            this.resultCallback.completed(this.problemDetailConsumer.generateContent());
            return;
        }
        this.inputStream.endOfStream();
        this.completed = true;
    }

    public void releaseResources() {
    }

    @Override
    public void onCapacityAvailable(int increment) {
        if (this.capacityChannel != null && increment > 0) {
            try {
                this.capacityChannel.update(increment);
            }
            catch (IOException e) {
                this.failed(e);
            }
        }
    }
}

