/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.DocumentReference;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.CreateDocumentCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.DocumentReferenceResponse;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.DocumentReferenceResponseImpl;
import io.camunda.zeebe.client.impl.util.DocumentBuilder;
import java.io.InputStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDocumentCommandImpl
extends DocumentBuilder
implements CreateDocumentCommandStep1,
CreateDocumentCommandStep1.CreateDocumentCommandStep2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateDocumentCommandImpl.class);
    private String documentId;
    private String storeId;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CreateDocumentCommandImpl(JsonMapper jsonMapper, HttpClient httpClient, ZeebeClientConfiguration configuration) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.requestTimeout(configuration.getDefaultRequestTimeout());
    }

    @Override
    public FinalCommandStep<DocumentReferenceResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZeebeFuture<DocumentReferenceResponse> send() {
        try {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA);
            String name = this.getMetadata().getFileName();
            entityBuilder.addBinaryBody("file", this.getContent(), ContentType.DEFAULT_BINARY, name);
            String metadataString = this.jsonMapper.toJson(this.getMetadata());
            entityBuilder.addPart("metadata", (ContentBody)new StringBody(metadataString, ContentType.APPLICATION_JSON));
            HttpZeebeFuture<DocumentReferenceResponse> result = new HttpZeebeFuture<DocumentReferenceResponse>();
            HashMap<String, String> queryParams = new HashMap<String, String>();
            if (this.documentId != null) {
                queryParams.put("documentId", this.documentId);
            }
            if (this.storeId != null) {
                queryParams.put("storeId", this.storeId);
            }
            this.httpClient.postMultipart("/documents", queryParams, entityBuilder, this.httpRequestConfig.build(), DocumentReference.class, DocumentReferenceResponseImpl::new, result);
            HttpZeebeFuture<DocumentReferenceResponse> httpZeebeFuture = result;
            return httpZeebeFuture;
        }
        finally {
            try {
                this.getContent().close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close content stream", (Throwable)e);
            }
        }
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 content(InputStream content) {
        super.content(content);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 content(byte[] content) {
        super.content(content);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 content(String content) {
        super.content(content);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 contentType(String contentType) {
        super.contentType(contentType);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 fileName(String name) {
        super.fileName(name);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 timeToLive(Duration timeToLive) {
        super.timeToLive(timeToLive);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 customMetadata(String key, Object value) {
        super.customMetadata(key, value);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 customMetadata(Map<String, Object> customMetadata) {
        super.customMetadata(customMetadata);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 processDefinitionId(String processDefinitionId) {
        super.getMetadata().setProcessDefinitionId(processDefinitionId);
        return this;
    }

    @Override
    public CreateDocumentCommandStep1.CreateDocumentCommandStep2 processInstanceKey(long processInstanceKey) {
        super.getMetadata().setProcessInstanceKey(ParseUtil.keyToString(processInstanceKey));
        return this;
    }
}

