/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.client.protocol.rest.UserTaskCompletionRequest;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.CompleteUserTaskCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.CompleteUserTaskResponse;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class CompleteUserTaskCommandImpl
implements CompleteUserTaskCommandStep1 {
    private final long userTaskKey;
    private final UserTaskCompletionRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CompleteUserTaskCommandImpl(HttpClient httpClient, JsonMapper jsonMapper, long userTaskKey) {
        this.jsonMapper = jsonMapper;
        this.userTaskKey = userTaskKey;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new UserTaskCompletionRequest();
    }

    @Override
    public FinalCommandStep<CompleteUserTaskResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<CompleteUserTaskResponse> send() {
        HttpZeebeFuture<CompleteUserTaskResponse> result = new HttpZeebeFuture<CompleteUserTaskResponse>();
        this.httpClient.post("/user-tasks/" + this.userTaskKey + "/completion", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), result);
        return result;
    }

    @Override
    public CompleteUserTaskCommandStep1 action(String action) {
        this.request.setAction(action);
        return this;
    }

    @Override
    public CompleteUserTaskCommandStep1 variables(Map<String, Object> variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        this.request.setVariables(variables);
        return this;
    }
}

