/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.client.protocol.rest.SignalBroadcastRequest;
import io.camunda.client.protocol.rest.SignalBroadcastResult;
import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.BroadcastSignalCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.BroadcastSignalResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.CommandWithVariables;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.BroadcastSignalResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class BroadcastSignalCommandImpl
extends CommandWithVariables<BroadcastSignalCommandImpl>
implements BroadcastSignalCommandStep1,
BroadcastSignalCommandStep1.BroadcastSignalCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private final GatewayOuterClass.BroadcastSignalRequest.Builder grpcRequestObjectBuilder;
    private Duration requestTimeout;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final SignalBroadcastRequest httpRequestObject;
    private boolean useRest;

    public BroadcastSignalCommandImpl(GatewayGrpc.GatewayStub asyncStub, ZeebeClientConfiguration config, JsonMapper jsonMapper, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.retryPredicate = retryPredicate;
        this.grpcRequestObjectBuilder = GatewayOuterClass.BroadcastSignalRequest.newBuilder();
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new SignalBroadcastRequest();
        this.useRest = config.preferRestOverGrpc();
        this.tenantId(config.getDefaultTenantId());
        this.requestTimeout(config.getDefaultRequestTimeout());
    }

    @Override
    protected BroadcastSignalCommandImpl setVariablesInternal(String variables) {
        this.grpcRequestObjectBuilder.setVariables(variables);
        if (this.useRest) {
            this.httpRequestObject.setVariables(this.objectMapper.fromJsonAsMap(variables));
        }
        return this;
    }

    @Override
    public BroadcastSignalCommandStep1.BroadcastSignalCommandStep2 signalName(String signalName) {
        this.grpcRequestObjectBuilder.setSignalName(signalName);
        this.httpRequestObject.setSignalName(signalName);
        return this;
    }

    @Override
    public BroadcastSignalCommandStep1.BroadcastSignalCommandStep2 tenantId(String tenantId) {
        this.grpcRequestObjectBuilder.setTenantId(tenantId);
        this.httpRequestObject.setTenantId(tenantId);
        return this;
    }

    @Override
    public FinalCommandStep<BroadcastSignalResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<BroadcastSignalResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private ZeebeFuture<BroadcastSignalResponse> sendRestRequest() {
        HttpZeebeFuture<BroadcastSignalResponse> result = new HttpZeebeFuture<BroadcastSignalResponse>();
        this.httpClient.post("/signals/broadcast", this.objectMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), SignalBroadcastResult.class, BroadcastSignalResponseImpl::new, result);
        return result;
    }

    public ZeebeFuture<BroadcastSignalResponse> sendGrpcRequest() {
        GatewayOuterClass.BroadcastSignalRequest request = this.grpcRequestObjectBuilder.build();
        RetriableClientFutureImpl<BroadcastSignalResponse, GatewayOuterClass.BroadcastSignalResponse> future = new RetriableClientFutureImpl<BroadcastSignalResponse, GatewayOuterClass.BroadcastSignalResponse>(BroadcastSignalResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.BroadcastSignalResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.BroadcastSignalResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.BroadcastSignalRequest request, StreamObserver<GatewayOuterClass.BroadcastSignalResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).broadcastSignal(request, streamObserver);
    }

    @Override
    public BroadcastSignalCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public BroadcastSignalCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }
}

