/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl;

import io.camunda.zeebe.client.CredentialsProvider;
import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZeebeCallCredentials
extends CallCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeCallCredentials.class);
    private final CredentialsProvider credentialsProvider;

    ZeebeCallCredentials(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        if (requestInfo.getSecurityLevel().ordinal() < SecurityLevel.PRIVACY_AND_INTEGRITY.ordinal()) {
            LOG.warn("The request's security level does not guarantee that the credentials will be confidential.");
        }
        appExecutor.execute(() -> {
            try {
                Metadata headers = new Metadata();
                this.credentialsProvider.applyCredentials(CredentialsProvider.CredentialsApplier.ofMetadata(headers));
                applier.apply(headers);
            }
            catch (IOException e) {
                applier.fail(Status.CANCELLED.withCause((Throwable)e));
            }
        });
    }

    public void thisUsesUnstableApi() {
    }
}

