/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"from", "limit", "searchAfter", "searchBefore"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchQueryPageRequest {
    public static final String JSON_PROPERTY_FROM = "from";
    @Nullable
    private Integer from;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    @Nullable
    private Integer limit = 100;
    public static final String JSON_PROPERTY_SEARCH_AFTER = "searchAfter";
    @Nullable
    private List<Object> searchAfter = new ArrayList<Object>();
    public static final String JSON_PROPERTY_SEARCH_BEFORE = "searchBefore";
    @Nullable
    private List<Object> searchBefore = new ArrayList<Object>();

    public SearchQueryPageRequest from(@Nullable Integer from) {
        this.from = from;
        return this;
    }

    @Nullable
    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFrom() {
        return this.from;
    }

    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFrom(@Nullable Integer from) {
        this.from = from;
    }

    public SearchQueryPageRequest limit(@Nullable Integer limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLimit(@Nullable Integer limit) {
        this.limit = limit;
    }

    public SearchQueryPageRequest searchAfter(@Nullable List<Object> searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    public SearchQueryPageRequest addSearchAfterItem(Object searchAfterItem) {
        if (this.searchAfter == null) {
            this.searchAfter = new ArrayList<Object>();
        }
        this.searchAfter.add(searchAfterItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="searchAfter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getSearchAfter() {
        return this.searchAfter;
    }

    @JsonProperty(value="searchAfter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchAfter(@Nullable List<Object> searchAfter) {
        this.searchAfter = searchAfter;
    }

    public SearchQueryPageRequest searchBefore(@Nullable List<Object> searchBefore) {
        this.searchBefore = searchBefore;
        return this;
    }

    public SearchQueryPageRequest addSearchBeforeItem(Object searchBeforeItem) {
        if (this.searchBefore == null) {
            this.searchBefore = new ArrayList<Object>();
        }
        this.searchBefore.add(searchBeforeItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="searchBefore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getSearchBefore() {
        return this.searchBefore;
    }

    @JsonProperty(value="searchBefore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchBefore(@Nullable List<Object> searchBefore) {
        this.searchBefore = searchBefore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchQueryPageRequest searchQueryPageRequest = (SearchQueryPageRequest)o;
        return Objects.equals(this.from, searchQueryPageRequest.from) && Objects.equals(this.limit, searchQueryPageRequest.limit) && Objects.equals(this.searchAfter, searchQueryPageRequest.searchAfter) && Objects.equals(this.searchBefore, searchQueryPageRequest.searchBefore);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.limit, this.searchAfter, this.searchBefore);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchQueryPageRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    searchAfter: ").append(this.toIndentedString(this.searchAfter)).append("\n");
        sb.append("    searchBefore: ").append(this.toIndentedString(this.searchBefore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getFrom() != null) {
            try {
                joiner.add(String.format("%sfrom%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFrom()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLimit() != null) {
            try {
                joiner.add(String.format("%slimit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLimit()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSearchAfter() != null) {
            for (i = 0; i < this.getSearchAfter().size(); ++i) {
                try {
                    joiner.add(String.format("%ssearchAfter%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getSearchAfter().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getSearchBefore() != null) {
            for (i = 0; i < this.getSearchBefore().size(); ++i) {
                try {
                    joiner.add(String.format("%ssearchBefore%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getSearchBefore().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

