/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.statistics.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.statistics.filter.ProcessDefinitionStatisticsFilter;
import io.camunda.client.api.statistics.request.ProcessDefinitionElementStatisticsRequest;
import io.camunda.client.api.statistics.response.ProcessElementStatistics;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.statistics.response.StatisticsResponseMapper;
import io.camunda.client.protocol.rest.ProcessDefinitionElementStatisticsQuery;
import io.camunda.client.protocol.rest.ProcessDefinitionElementStatisticsQueryResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessDefinitionElementStatisticsRequestImpl
extends TypedSearchRequestPropertyProvider<ProcessDefinitionElementStatisticsQuery>
implements ProcessDefinitionElementStatisticsRequest {
    private final long processDefinitionKey;
    private final ProcessDefinitionElementStatisticsQuery request = new ProcessDefinitionElementStatisticsQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public ProcessDefinitionElementStatisticsRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, long processDefinitionKey) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.processDefinitionKey = processDefinitionKey;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalCommandStep<List<ProcessElementStatistics>> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<List<ProcessElementStatistics>> send() {
        HttpCamundaFuture<List<ProcessElementStatistics>> result = new HttpCamundaFuture<List<ProcessElementStatistics>>();
        this.httpClient.post("/process-definitions/" + this.processDefinitionKey + "/statistics/element-instances", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), ProcessDefinitionElementStatisticsQueryResult.class, StatisticsResponseMapper::toProcessDefinitionStatisticsResponse, result);
        return result;
    }

    @Override
    public ProcessDefinitionElementStatisticsRequest filter(ProcessDefinitionStatisticsFilter value) {
        this.request.setFilter((io.camunda.client.protocol.rest.ProcessDefinitionStatisticsFilter)ProcessDefinitionElementStatisticsRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public ProcessDefinitionElementStatisticsRequest filter(Consumer<ProcessDefinitionStatisticsFilter> fn) {
        return this.filter(SearchRequestBuilders.processDefinitionStatisticsFilter(fn));
    }

    @Override
    protected ProcessDefinitionElementStatisticsQuery getSearchRequestProperty() {
        return this.request;
    }
}

