/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.search.request.ProcessInstanceSequenceFlowsRequest;
import io.camunda.client.api.search.response.ProcessInstanceSequenceFlow;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.ProcessInstanceSequenceFlowsQueryResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessInstanceSequenceFlowsRequestImpl
implements ProcessInstanceSequenceFlowsRequest {
    private final long processInstanceKey;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public ProcessInstanceSequenceFlowsRequestImpl(HttpClient httpClient, long processInstanceKey) {
        this.httpClient = httpClient;
        this.processInstanceKey = processInstanceKey;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalCommandStep<List<ProcessInstanceSequenceFlow>> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<List<ProcessInstanceSequenceFlow>> send() {
        HttpCamundaFuture<List<ProcessInstanceSequenceFlow>> result = new HttpCamundaFuture<List<ProcessInstanceSequenceFlow>>();
        this.httpClient.get("/process-instances/" + this.processInstanceKey + "/sequence-flows", this.httpRequestConfig.build(), ProcessInstanceSequenceFlowsQueryResult.class, SearchResponseMapper::toProcessInstanceSequenceFlowSearchResponse, result);
        return result;
    }
}

