/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.search.filter.AdHocSubProcessActivityFilter;
import io.camunda.client.api.search.request.AdHocSubProcessActivitySearchRequest;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.response.AdHocSubProcessActivityResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.AdHocSubProcessActivityResponseImpl;
import io.camunda.client.protocol.rest.AdHocSubProcessActivitySearchQuery;
import io.camunda.client.protocol.rest.AdHocSubProcessActivitySearchQueryResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class AdHocSubProcessActivitySearchRequestImpl
implements AdHocSubProcessActivitySearchRequest {
    private final AdHocSubProcessActivitySearchQuery request = new AdHocSubProcessActivitySearchQuery();
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public AdHocSubProcessActivitySearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AdHocSubProcessActivitySearchRequest filter(AdHocSubProcessActivityFilter filter) {
        this.request.setFilter((io.camunda.client.protocol.rest.AdHocSubProcessActivityFilter)TypedSearchRequestPropertyProvider.provideSearchRequestProperty(filter));
        return this;
    }

    @Override
    public AdHocSubProcessActivitySearchRequest filter(Consumer<AdHocSubProcessActivityFilter> fn) {
        return this.filter(SearchRequestBuilders.adHocSubProcessActivityFilter(fn));
    }

    @Override
    public FinalCommandStep<AdHocSubProcessActivityResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AdHocSubProcessActivityResponse> send() {
        HttpCamundaFuture<AdHocSubProcessActivityResponse> result = new HttpCamundaFuture<AdHocSubProcessActivityResponse>();
        this.httpClient.post("/element-instances/ad-hoc-activities/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), AdHocSubProcessActivitySearchQueryResult.class, AdHocSubProcessActivityResponseImpl::new, result);
        return result;
    }
}

