/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.impl.NoopCredentialsProvider;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.util.VersionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.HttpClientHostnameVerifier;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class HttpClientFactory {
    public static final String REST_API_PATH = "/v2";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private final CamundaClientConfiguration config;

    public HttpClientFactory(CamundaClientConfiguration config) {
        this.config = config;
    }

    public HttpClient createClient() {
        RequestConfig defaultRequestConfig = this.defaultClientRequestConfigBuilder().build();
        CloseableHttpAsyncClient client = this.defaultClientBuilder().setDefaultRequestConfig(defaultRequestConfig).build();
        URI gatewayAddress = this.buildGatewayAddress();
        CredentialsProvider credentialsProvider = this.config.getCredentialsProvider() != null ? this.config.getCredentialsProvider() : new NoopCredentialsProvider();
        return new HttpClient(client, JSON_MAPPER, gatewayAddress, defaultRequestConfig, this.config.getMaxMessageSize(), TimeValue.ofSeconds((long)15L), credentialsProvider);
    }

    private URI buildGatewayAddress() {
        String basePath = this.config.getRestAddress().toString();
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        try {
            URIBuilder builder = new URIBuilder(basePath).appendPath(REST_API_PATH);
            builder.setScheme(this.config.isPlaintextConnectionEnabled() ? "http" : "https");
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpAsyncClientBuilder defaultClientBuilder() {
        BasicHeader acceptHeader = new BasicHeader("Accept", (Object)String.join((CharSequence)", ", ContentType.APPLICATION_JSON.getMimeType(), ContentType.APPLICATION_PROBLEM_JSON.getMimeType()));
        HostnameVerifier hostnameVerifier = new HostnameVerifier(this.config.getOverrideAuthority());
        TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(this.createSslContext()).setHostnameVerifier((javax.net.ssl.HostnameVerifier)((Object)hostnameVerifier)).build();
        PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).build();
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setConnectionManager((AsyncClientConnectionManager)connectionManager).setDefaultHeaders(Collections.singletonList(acceptHeader)).setUserAgent("camunda-client-java/" + VersionUtil.getVersion()).evictExpiredConnections().setCharCodingConfig(CharCodingConfig.custom().setCharset(StandardCharsets.UTF_8).build()).evictIdleConnections(TimeValue.ofSeconds((long)30L)).useSystemProperties();
        List<AsyncExecChainHandler> chainHandlers = this.config.getChainHandlers();
        IntStream.range(0, chainHandlers.size()).forEach(i -> builder.addExecInterceptorLast("handler-" + i, (AsyncExecChainHandler)chainHandlers.get(i)));
        return builder;
    }

    private RequestConfig.Builder defaultClientRequestConfigBuilder() {
        return RequestConfig.custom().setResponseTimeout(Timeout.of((Duration)this.config.getDefaultRequestTimeout())).setConnectionKeepAlive(TimeValue.of((Duration)this.config.getKeepAlive())).setHardCancellationEnabled(false);
    }

    private SSLContext createSslContext() {
        if (this.config.isPlaintextConnectionEnabled() || this.config.getCaCertificatePath() == null) {
            return SSLContexts.createDefault();
        }
        KeyStore keyStore = this.createKeyStore();
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(keyStore);
            SSLContext context = SSLContexts.custom().build();
            context.init(null, factory.getTrustManagers(), null);
            return context;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore createKeyStore() {
        KeyStore keyStore;
        File pemChain = new File(this.config.getCaCertificatePath());
        FileInputStream certificateStream = new FileInputStream(pemChain);
        try {
            KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
            store.load(null);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            int i = 1;
            while (certificateStream.available() > 0) {
                Certificate certificate = certificateFactory.generateCertificate(certificateStream);
                String alias = Integer.toString(i);
                store.setCertificateEntry(alias, certificate);
                ++i;
            }
            keyStore = store;
        }
        catch (Throwable throwable) {
            try {
                try {
                    certificateStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException(e);
            }
        }
        certificateStream.close();
        return keyStore;
    }

    private static final class HostnameVerifier
    implements HttpClientHostnameVerifier {
        private final HttpClientHostnameVerifier delegate = new DefaultHostnameVerifier();
        private final String overriddenAuthority;

        private HostnameVerifier(String overriddenAuthority) {
            this.overriddenAuthority = overriddenAuthority;
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
            String hostname;
            String string = hostname = "0.0.0.0".equals(host) ? "localhost" : host;
            if (this.overriddenAuthority != null) {
                this.delegate.verify(this.overriddenAuthority, cert);
            } else {
                this.delegate.verify(hostname, cert);
            }
        }

        public boolean verify(String hostname, SSLSession session) {
            String host = "0.0.0.0".equals(hostname) ? "localhost" : hostname;
            return this.delegate.verify(this.overriddenAuthority == null ? host : this.overriddenAuthority, session);
        }
    }
}

